/*=================================================================
 *
 * cum_max_c.c ... Compute running maxium (row-wise)
 *
 * The calling syntax is:
 *
 *		cum_max_c([1 2 0; 3 4 2])
 *
 *
 *=================================================================*/

#include <math.h>
#include "mex.h"

#ifndef max
#define max(a,b) (((a) > (b)) ? (a) : (b))
#endif

/* Recursive computation of loss distribution */
static void cum_max_c(double numbers[], double cummax[], unsigned int num_points1, unsigned int num_points2)
{
    int i, j, index;
    
    for (i=0; i<num_points1; i++)
    {
        cummax[i] = numbers[i];
    }
    
    for (i=0; i<num_points1; i++)
    {
        index = i;
        for (j=1; j < num_points2; j++)
        {
            index += num_points1;
            cummax[index] = max(numbers[index], cummax[index-num_points1]);
        }
    }
    return;
}


/* Gateway routine (to Matlab) */
void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{ 
    double *numbers; 
    double *cummax;
    unsigned int num_points1, num_points2; 

    /* Get number of data points */
    num_points1 = mxGetM(prhs[0]);
    num_points2 = mxGetN(prhs[0]);
    
    /* Create a mtrix for the return argument */ 
    plhs[0] = mxCreateDoubleMatrix(num_points1, num_points2, mxREAL); 
    
    /* Assign pointers to the various parameters */ 
    numbers = mxGetPr(prhs[0]);
    cummax = mxGetPr(plhs[0]);
        
    /* Do the actual computations in a subroutine */
    cum_max_c(numbers, cummax, num_points1, num_points2); 
    return;
}
