function T = date_diff_years(date_num1, date_num2)
% --------------------------------------------------------------------------------------------------
% Calculate the difference (date2-date1 in years) between two dates, using the 30/360 day count
% convention.
% --------------------------------------------------------------------------------------------------
% sample call: date_diff_years(datenum('2/20/2007'), datenum('1/30/2008'))
% --------------------------------------------------------------------------------------------------

date_details = datevec(date_num1);
date_details2 = datevec(date_num2);
year_diff  = date_details2(1) - date_details(1);
month_diff = date_details2(2) - date_details(2);
day_diff   = date_details2(3) - date_details(3);
T = year_diff + month_diff/12 + day_diff/12/30;
    