function dates = get_IMM_dates(start_date, end_date)
% --------------------------------------------------------------------------------------------------
% Return all IMM dates between start_date and end_date (both inclusive).
% --------------------------------------------------------------------------------------------------
% sample call: get_IMM_dates('01/01/2005', '01/01/2008')
% --------------------------------------------------------------------------------------------------

start_date = datenum(start_date);
end_date = datenum(end_date);
IMM_dates = {'3/20/2003' '6/20/2003' '9/22/2003' '12/22/2003' '3/22/2004' '6/21/2004' '9/20/2004' '12/20/2004' ...
             '3/21/2005' '6/20/2005' '9/20/2005' '12/20/2005' '3/20/2006' '6/20/2006' '9/20/2006' '12/20/2006' ...
             '3/20/2007' '6/20/2007' '9/20/2007' '12/20/2007' '3/20/2008' '6/20/2008' '9/22/2008' '12/22/2008' ...
             '3/20/2009' '6/22/2009' '9/21/2009' '12/21/2009' '3/22/2010' '6/21/2010' '9/20/2010' '12/20/2010' ...
             '3/21/2011' '6/20/2011' '9/20/2011' '12/20/2011' '3/20/2012' '6/20/2012' '9/20/2012' '12/20/2012' ...
             '3/20/2013' '6/20/2013' '9/20/2013' '12/20/2013' '3/20/2014' '6/20/2014' '9/22/2014' '12/22/2014' ...
             '3/20/2015' '6/22/2015' '9/21/2015' '12/21/2015' '3/21/2016' '6/20/2016' '9/20/2016' '12/20/2016' ...
             '3/20/2017' '6/20/2017' '9/20/2017' '12/21/2017' '3/21/2018' '6/20/2018' '9/20/2018' '12/20/2018'};
IMM_dates = datenum(IMM_dates);
start_pos = find(IMM_dates >= start_date, 1, 'first');
end_pos = find(IMM_dates <= end_date, 1, 'last');
if (~isempty(start_pos)) & (~isempty(end_pos))
    dates = IMM_dates(start_pos:end_pos);
else
    dates = [];
end