function dates = get_dates_month_evenly(dates, k)
% --------------------------------------------------------------------------------------------------
% Given a list of dates, return k evenly spaced dates from each month.
% --------------------------------------------------------------------------------------------------
% dates     ... list of dates
% k         ... number of dates to select from each month
% --------------------------------------------------------------------------------------------------
% sample call: get_dates_month_evenly(CDX_NA_IG2.dates{1}, 2)
% --------------------------------------------------------------------------------------------------

[Y, M, D] = datevec(dates);
month_start_pos = find(diff([0; M]) > 0);
dates_pos = [];
for i=1:(length(month_start_pos)-1)
    spacing = floor((month_start_pos(i+1) - month_start_pos(i))/k);
    if (spacing >= 1)
        dates_pos = [dates_pos; (month_start_pos(i):spacing:(month_start_pos(i+1)-1))'];
    else
        date_pos = [dates_pos; month_start_pos(i)];
    end
end
date_pos = [dates_pos; month_start_pos(end)];
dates = datenum(Y(date_pos), M(date_pos), D(date_pos));