function smoothed = ewma(series, alpha, min_ewma)
% Compute exponentially weighted moving average with decay parameter alpha
%
% series   ... time series
% alpha    ... decay parameter for ewma
% min_eqma ... minimum value to use in iterative calculation

T = length(series);
smoothed = max(mean(series), min_ewma);
for t=2:T
   smoothed(t) = alpha * max(min_ewma, smoothed(t-1)) + (1-alpha) * series(t);
   smoothed(t) = max(min_ewma, smoothed(t));
end