function matching_pos = fuzzy_datenum_match(datenum1, datenum2)
% --------------------------------------------------------------------------------------------------
% For each datanum in the first series, find the position in the second series whose datenum is
% closest.
% --------------------------------------------------------------------------------------------------
% datenum1      ... series of datenums to be fuzzy-matched with second series
% datenum2      ... second series
% --------------------------------------------------------------------------------------------------
% sample call: fuzzy_datenum_match(datenum(data_chtr.dates), sp500.dates)
% --------------------------------------------------------------------------------------------------

if (isempty(datenum2))
    matching_pos = [];
    return
end

matching_pos = zeros(length(datenum1), 1);
for i=1:length(datenum1)
    % Determine best matching num in second series - if two are of equal distance, take first entry
    diff = abs(datenum2 - datenum1(i));
    matching_pos(i) = find(diff == min(diff), 1, 'first');
end