function pos = interpolate_pos(a, b, n)
% --------------------------------------------------------------------------------------------------
% For each element in 1:n, determine the most recent available data i, subject to the constraints:
% (i) if i=b(j) for some j, then b(j)=a(j)
% (ii) the output is monotone
%
% For example: ([2 3 5], [3 4 6], 7) --> [3 3 4 4 6 6 6]
% --------------------------------------------------------------------------------------------------
% a,b   ... matching indices 
% n     ... number of elements to match
% --------------------------------------------------------------------------------------------------
% sample call: interpolate_pos([2 3 5], [3 4 6], 7)
% --------------------------------------------------------------------------------------------------

pos = zeros(1,n);

% If not data availabe at beginning, use b(1)
pos(1:(a(1)-1)) = b(1);

% Fill data in the middle
for i=1:(length(a)-1)
    pos(a(i):(a(i+1)-1)) = b(i);
end

% At the end, use last available element of b
pos(a(end):n) = b(end);
