/*=================================================================
 *
 * surv_prob_c.c ...  Same as 'surv_prob.m': Calculate the survival probability of a company when
 *                    the default intensity follows an affine jump diffusion.
 *
 * The calling syntax is:
 *
 *		[ind, pos] = is_member_sorted_c(elements, target_set)
 *
 * sample: is_member_sorted_c([5; 7; 10], [1; 3; 5; 7; 10; 15])
 *
 *=================================================================*/

#include <math.h>
#include "mex.h"

#ifndef max
#define max(a,b) (((a) > (b)) ? (a) : (b))
#endif

/* Recursive computation of loss distribution */
static void is_member_sorted_c(double ind[], double pos[], double set1[], double set2[], double num_elements1, double num_elements2)
{
    int i, j;
    double tmp;

    j = 0;
    for (i=0; i<num_elements1; i++)
    {
        tmp = set1[i];
        ind[i] = 0;
        pos[i] = 0;
        while ((j < num_elements2) && (set2[j] < tmp - 1e-10))
        {
                j++;
        }
        if (j < num_elements2)
        {
            if ((tmp-set2[j] < 1e-10) && (tmp-set2[j] > -1e-10)) {
                ind[i] = 1;
                pos[i] = j+1;
            }
        }
    }
    return;
}


/* Gateway routine (to Matlab) */
void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{ 
    double *set1, *set2;
    double *ind, *pos, M, N;
    unsigned int num_elements1, num_elements2; 

    /* Get number of elements in both sets */
    M = mxGetM(prhs[0]); 
    N = mxGetN(prhs[0]);
    num_elements1 = max(M, N);
    if ((M==0) | (N==0))
    {
        num_elements1 = 0;
    }
    M = mxGetM(prhs[1]); 
    N = mxGetN(prhs[1]);
    num_elements2 = max(M,N);
    if ((M==0) | (N==0))
    {
        num_elements2 = 0;
    }
    
    /* Assign pointers to the input variables parameters */ 
    set1 = mxGetPr(prhs[0]);
    set2 = mxGetPr(prhs[1]);
    
    /* Create a mtrix for the return arguments */ 
    plhs[0] = mxCreateDoubleMatrix(num_elements1, 1, mxREAL);
    plhs[1] = mxCreateDoubleMatrix(num_elements1, 1, mxREAL);
    ind = mxGetPr(plhs[0]);
    pos = mxGetPr(plhs[1]);
        
    /* Do the actual computations in a subroutine */
    if (num_elements2 > 0)
    {
        is_member_sorted_c(ind, pos, set1, set2, num_elements1, num_elements2);
    }
    /* ind[0] = num_elements1; */
    /* p[1] = num_elements2; */
    return;
}
