function matching_imm_dates = match_imm_dates(date_nums, maturity)
% --------------------------------------------------------------------------------------------------
% Given a list of dates, return a list of closest IMM dates, that are at least 'maturity' years
% away.
% --------------------------------------------------------------------------------------------------
% date_nums ... list of dates to be processed (vector of datenums)
% maturity  ... minimum time difference in years between dates and IMM dates
% --------------------------------------------------------------------------------------------------
% sample call: datestr(match_imm_dates(today:5:(today+90), 5), 23)
% --------------------------------------------------------------------------------------------------

% Define IMM dates
IMM_dates = {'3/20/2003' '6/20/2003' '9/22/2003' '12/22/2003' '3/22/2004' '6/21/2004' '9/20/2004' '12/20/2004' ...
             '3/21/2005' '6/20/2005' '9/20/2005' '12/20/2005' '3/20/2006' '6/20/2006' '9/20/2006' '12/20/2006' ...
             '3/20/2007' '6/20/2007' '9/20/2007' '12/20/2007' '3/20/2008' '6/20/2008' '9/22/2008' '12/22/2008' ...
             '3/20/2009' '6/22/2009' '9/21/2009' '12/21/2009' '3/22/2010' '6/21/2010' '9/20/2010' '12/20/2010' ...
             '3/21/2011' '6/20/2011' '9/20/2011' '12/20/2011' '3/20/2012' '6/20/2012' '9/20/2012' '12/20/2012' ...
             '3/20/2013' '6/20/2013' '9/20/2013' '12/20/2013' '3/20/2014' '6/20/2014' '9/22/2014' '12/22/2014' ...
             '3/20/2015' '6/22/2015' '9/21/2015' '12/21/2015' '3/21/2016' '6/20/2016' '9/20/2016' '12/20/2016' ...
             '3/20/2017' '6/20/2017' '9/20/2017' '12/21/2017' '3/21/2018' '6/20/2018' '9/20/2018' '12/20/2018'};
IMM_dates = datenum(IMM_dates);
matching_imm_dates = zeros(length(date_nums), 1);

% Determine matiching IMM date
for i=1:length(date_nums)
    for j=length(IMM_dates):(-1):1
        T = date_diff_years(date_nums(i), IMM_dates(j));
        if (T >= maturity)
            matching_imm_dates(i) = IMM_dates(j);
        end
    end
end