function matching_dates = match_index_maturity_dates(date_nums, maturity)
% --------------------------------------------------------------------------------------------------
% Given a list of dates, return a list of closest index maturity dates (every other IMM date), that
% are at least 'maturity' years away.
% --------------------------------------------------------------------------------------------------
% date_nums ... list of dates to be processed (vector of datenums)
% maturity  ... minimum time difference in years between dates and IMM dates
% --------------------------------------------------------------------------------------------------
% sample call: datestr(match_index_maturity_dates(today:10:(today+180), 4.75), 23)
%              datestr(match_index_maturity_dates(datenum('03/18/2007'):datenum('03/22/2007'), 4.75), 23)
% --------------------------------------------------------------------------------------------------

% Define IMM dates
IMM_dates = {'6/20/2003' '12/22/2003' '6/22/2004' '12/20/2004' '6/21/2005' '12/20/2005' '6/20/2006' '12/20/2006' ...
             '6/20/2007' '12/20/2007' '6/20/2008' '12/22/2008' '6/20/2009' '12/21/2009' '6/22/2010' '12/20/2010' ...
             '6/21/2011' '12/20/2011' '6/20/2012' '12/20/2012' '6/20/2013' '12/20/2013' '6/20/2014' '12/22/2014' ...
             '6/20/2015' '12/21/2015' '6/21/2016' '12/20/2016' '6/20/2017' '12/20/2017' '6/21/2018' '12/20/2018' };
IMM_dates = datenum(IMM_dates);
matching_dates = zeros(length(date_nums), 1);

% Determine matiching IMM date
for i=1:length(date_nums)
    for j=length(IMM_dates):(-1):1
        T = date_diff_years(date_nums(i), IMM_dates(j));
        if (T >= maturity)
            matching_dates(i) = IMM_dates(j);
        end
    end
end