/*=================================================================
 *
 * previous_pos_c.c ...  for each numer in x2, determine the position of the number in x that is smaller or equal its value
 *
 * The calling syntax is:
 *
 *		previous_pos_c(x, x2)
 *
 * x, x2    ... sorted array of numbers
 *
 * Sample call:
 *  
 *      previous_pos_c([2 3 4 5 6], [2.5 3 3.5])
 *=================================================================*/

#include <math.h>
#include "mex.h"

#ifndef max
#define max(a,b) (((a) > (b)) ? (a) : (b))
#endif

/* Recursive computation of loss distribution */
static void previous_pos_c(double pos[], double x[], double x2[], unsigned int num_points_x, unsigned int num_points_x2)
{
    int i, j; 
    
    j = num_points_x - 1;
    for (i=num_points_x2 - 1; i>=0; i--)
    {
        while ((x[j] > x2[i]) && (j > 0))
        {
            j--;
        }
        pos[i] = j + 1;
    }
    return;
}


/* Gateway routine (to Matlab) */
void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{ 
    double *x, *x2, *pos; 
    unsigned int num_points1, num_points2, num_points_x, num_points_x2; 

    /* Get number of data points */
    num_points1 = mxGetM(prhs[0]);
    num_points2 = mxGetN(prhs[0]);
    num_points_x = max(num_points1, num_points2);
    num_points1 = mxGetM(prhs[1]);
    num_points2 = mxGetN(prhs[1]);
    num_points_x2 = max(num_points1, num_points2);
    
    /* Create a mtrix for the return argument */ 
    plhs[0] = mxCreateDoubleMatrix(num_points_x2, 1, mxREAL); 
    
    /* Assign pointers to the various parameters */ 
    x = mxGetPr(prhs[0]);
    x2 = mxGetPr(prhs[1]);
    pos = mxGetPr(plhs[0]);
        
    /* Do the actual computations in a subroutine */
    previous_pos_c(pos, x, x2, num_points_x, num_points_x2); 
    return;
}
