function rol_med = rolling_median(values, window_length)
% --------------------------------------------------------------------------------------------------
% Calculate rolling median of length 'length' for a time series
% --------------------------------------------------------------------------------------------------
% values    ... time series values
% length    ... length of rolling median window
% --------------------------------------------------------------------------------------------------
% sample call: rolling_median(CDX_NA_IG2.portfolio(1).market_price{1}, 20)
% --------------------------------------------------------------------------------------------------

% Iteratively calculate median (speed can probably increased a lot by keeping sorted array in memory)
n = length(values);
rol_med = zeros(n, 1);
for j=1:n
    range_min = max(1, j-window_length+1);
    rol_med(j) = median(values(range_min:j));
end