function [quantiles, weights, weights_middle] = sparse_density2(density, dz, num_quantiles)
% --------------------------------------------------------------------------------------------------
% Convert a density with regular spacings into a sparse representation based on (i) quantiles and
% (ii) the value of the density at these quantiles (iii) the value of the density exactly in the
% middle (spacially) between two adjacent quantiles
% --------------------------------------------------------------------------------------------------
% density           ... density at points dz*(j-1)
% dz                ... spacing of density
% num_quantiles     ... number of points for new density approximation
% --------------------------------------------------------------------------------------------------
% sample call: [points, weights, weights_midle] = sparse_density2(1:100, 1, 10)
% --------------------------------------------------------------------------------------------------

% Determine support points for density
num_quantiles = num_quantiles - 2;
cum_density = cumsum(density);
cum_density = cum_density / cum_density(end);
points_pos = [];
K = num_quantiles;
counter = 0;
while (length(points_pos) < K * 0.5) & (counter < 6)
    % Define quantiles and invert CDF
    counter = counter + 1;
    grid_quantiles = [0 (1/2/num_quantiles):(1/num_quantiles):(1-1/2/num_quantiles) 1];
    tmp = empirical_quantiles(cum_density, grid_quantiles);
    
    % Force quantile to be apart lesst than maximum/K*50
    max_diff = tmp(end)/K*50;
    diff_large = find(diff(tmp) > max_diff);
    tmp_new = tmp;
    for j = length(diff_large):(-1):1
        pos = diff_large(j);
        tmp_new = [tmp(1:(pos-1)); (tmp(pos):max_diff:tmp(pos+1))'; tmp_new(pos+1:end)];
    end
    tmp = tmp_new;
    
    % Determine point position and density
    [points_pos, index] = unique(round(tmp));
    num_quantiles = num_quantiles * 2;
end
points_pos_middle = (tmp(index(1:end-1)) + tmp(index(2:end))) / 2;
if (counter == 6)
    %disp('Warning: Has to increase num_quantiles six times');
end

% Determine corresponding weightes
quantiles = points_pos * dz;
weights = density(points_pos)';  

% Use linear interpolation to calculate density in middle of quantiles
w = (points_pos_middle - floor(points_pos_middle))';
weights_middle = density(floor(points_pos_middle)) .* (1-w) + density(ceil(points_pos_middle)) .* w;  