/*=================================================================
 *
 * used_range_c.c ...  return the position of all elements in 'elements' between start_element and end_element
 *
 * The calling syntax is:
 *
 *		[ind, pos] = used_range_c(elements, start_element, end_element)
 *
 * sample: [a,b] = used_range_c([1 2 5 6 7 8 9 10], 3, 9) returns [3 7]
 *         [a,b] = used_range_c([1 2 5 6 7 8 9 10], 3, 3)
 *
 *=================================================================*/

#include <math.h>
#include "mex.h"

#ifndef max
#define max(a,b) (((a) > (b)) ? (a) : (b))
#endif

/* Recursive computation of loss distribution */
static void used_range_c(double elements[], double start_element[], double end_element[], double start_pos[],
                         double end_pos[], unsigned int num_elements)
{
    unsigned int i, j;
    double tmp;

    /* Determine start_pos */
    tmp = start_element[0] - 1e-10;
    for (i=0; i<num_elements; i++)
    {
        if (elements[i] >= tmp)
        {
            start_pos[0] = (double) i+1;
            break;
        }
                
    }
    
    /* Determine end_pos */
    end_pos[0] = start_pos[0];
    tmp = end_element[0] + 1e-10;
    for (j=num_elements-1; j >= i+1; j--)
    {
        if (elements[j] <= tmp)
        {
            end_pos[0] = (double) j+1;
            break;
        }           
    }
    return;
}


/* Gateway routine (to Matlab) */
void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{ 
    double *elements, *start_element, *end_element;
    double *start_pos, *end_pos;
    unsigned int num_elements, M, N;

    /* Get number of elements */
    M = mxGetM(prhs[0]); 
    N = mxGetN(prhs[0]);
    num_elements = max(M, N);
    if ((M==0) | (N==0))
    {
        num_elements = 0;
    }
    
    /* Assign pointers to the input variables parameters */ 
    elements = mxGetPr(prhs[0]);
    start_element = mxGetPr(prhs[1]);
    end_element = mxGetPr(prhs[2]);
    
    /* Create a matrix for the return arguments */ 
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    plhs[1] = mxCreateDoubleMatrix(1, 1, mxREAL);
    start_pos = mxGetPr(plhs[0]);
    end_pos = mxGetPr(plhs[1]);
        
    /* Do the actual computations in a subroutine */
    if (num_elements > 0)
    {
        used_range_c(elements, start_element, end_element, start_pos, end_pos, num_elements);
    }
    /* p[0] = start[0]; */
    /* p[1] = start[1]; */
    return;
}
