% --------------------------------------------------------------------------------------------------
% Create artifical CDS, CDX index and CDX tranche dataset (time series with two dates)
% --------------------------------------------------------------------------------------------------

% Define generic CDS structure
cds_demo = struct('company', '', 'ticker', '', ...
  'dates', {{[732651; 732682], [732651; 732682], [732651; 732682], [732651; 732682]}}, ...
  'rating', [3; 3], 'market_price', {{[40; 45], [52; 58], [60; 68], [15; 17]}}, ...
  'x0', [0.0005; 0.0006], ...
  'AJD', struct('k', [-0.2; -0.18], 'theta', [-0.001; -0.001], 'sigma', [0.08; 0.08], 'L', [0.008; 0.0085], ...
                'mu', [0.15; 0.14], 'dates', [732651; 732682]), ...
  'LGD', 0.6, ...
  'T', {{[5.04167; 4.9583], [7.04167; 6.9583], [10.0444; 9.9611], [1.04167; 0.9583]}}, ...
  'intensity_P', [5e-5; 5.1e-5], ...
  'model_price', {{[0; 0], [0; 0], [0; 0], [0; 0]}}, ...
  'DTD', [6; 5.9], ...
  'return1yr', [0; 0], ...
  'ai', [1; 1], 'ai_P', [0.2; 0.2], ...
  'bi', [1; 1], 'bi_P', [0.5; 0.5] ...
);

% Build CDX structure
cdx_demo = struct( ...
    'dates', {{[732651; 732682], [732651; 732682], [732651; 732682]}}, ...
    'T', {{[5.04167; 4.9583], [7.04167; 6.9583], [10.0444; 9.9611]}}, 'cut_offs', {[0.03 0.07 0.1 0.15 0.3]}, ...
    'index_market_price', {{[40; 41], [50; 52], [65; 67]}}, ...
    'tranche_market_price_mid', {{[500 115 35 15 7.5; ...
                                   500 125 40 17 8.0] ...
                                                    [500 250 80 45 15; ...
                                                     500 270 85 48 16] ...
                                                                        [500 550 150 90 35;
                                                                         500 580 159 93 36.5]}}, ...
    'tranche_market_upfront_mid', {{[0.30 0 0 0 0; 0.31 0 0 0 0] ...
                                    [0.45 0 0 0 0; 0.46 0 0 0 0] ...
                                    [0.55 0 0 0 0; 0.56 0 0 0 0]}}, ...
    'portfolio', repmat(cds_demo, 125, 1), ...
    'AJD_common_factor', struct('k', [-0.2; -0.18], 'theta', [-0.0015; -0.0015], 'sigma', [0.08; 0.08], 'L', [0.002; 0.002], ...
                                'mu', [0.15; 0.14], 'dates', [732651; 732682]), ...    
    'index_members', {ones(2, 125)}, ...
    'LGD', struct('mean', 0.6, 'rho_n', ones(1, 125)), ...
    'y0', [0.0005; 0.00051], ...
    'liq_prem_cds', [0; 0], ...
    'liq_prem_tranches', [0; 0] ...
);
for i=1:length(cdx_demo.portfolio)
    cdx_demo.portfolio(i).ticker = ['Ticker_' num2str(i)];
end

% Define discount curves - Flat term structure of interest rates equal to 5%
horizons = [0.04167:0.25:10.0444;  0.2083:0.25:10.2083];
horizons_inbetween = ([[0; 0] horizons(:,1:end-1)] + horizons)/2;
discount_curves_demo = struct('dates', {[732651; 732682]}, ...
                              'discounts', {exp( -0.05 * horizons )}, ...
                              'discounts_inbetween', {exp( -0.05 * horizons_inbetween)}, ...
                              'horizon', {horizons}, 'horizon_inbetween', {horizons_inbetween} );                          