%--------------------------------------------------------------------------------------------------
% PURPOSE:  Demonstrate: 1.) pricing of credit tranches
%                        2.) tranche spread decomposition
%                        3.) decomposition of risk-neutral expected portfolio loss
%---------------------------------------------------------------------------------------------------
% USAGE: Just type 'demo' on the Matlab command prompt and press <ENTER>
%---------------------------------------------------------------------------------------------------
% REFERENCES: "Computational Techniques for basic Affine Models of Portfolio Credit Risk", Andreas Eckner, August 2007
%             "Risk Premia in Structured Credit Derivatives", Andreas Eckner, August, 2007.
%---------------------------------------------------------------------------------------------------
% Written by Andreas Eckner
%---------------------------------------------------------------------------------------------------


disp('***************************************************************')
disp('* Generating artifical CDS, CDX index and CDX tranche dataset *')
disp('***************************************************************')
disp(' ')

if (~exist('cdx_demo'))
    create_cdx_demo2;
end
                          
h = msgbox({'CDX structure ''cdx_demo'' created successfully' '' 'Press OK to continue.'}, 'Step 1', 'none');
uiwait(h);


disp('*********************************************************************')
disp('* Calculating model implied index and tranche spreads for all dates *')
disp('*********************************************************************')
disp(' ')

%cdx_demo = update_model_price_index(cdx_demo, discount_curves_demo, [1 1 1], datenum('12/05/2005'),  datenum('12/05/2005'));
[trash, cdx_demo] = wrapper_tranche_mispricing(get_x0(cdx_demo, [datenum('12/05/2005'); datenum('01/05/2006')]), cdx_demo, ...
                        discount_curves_demo, datenum('12/05/2005'), datenum('01/05/2006'), 2^18, [1 1 1 1], [1 1 1], 121, 0, 2, 'mu*L', 'thet*k');
                                                                              
disp(cdx_demo)
disp('Note line 4, 6, and 8 from below, with model-implied tranche and index spreads, respectively.')
h = msgbox({'Model implied CDX index and tranche spreads calculated successfully.' '' 'Press OK to continue.'}, 'Step 2', 'none');
uiwait(h);


disp('***************************************************************************************')
disp('* Demonstrating tranche spread decomposition on 12/5/2005 (takes a couple of seconds) *')
disp('***************************************************************************************')
disp(' ')

theta_P_demo = [0.5 1.5 0.0015];   % [k_X^P, l_X^P, mu_X^P]
tranche_spread_decomposition(cdx_demo, discount_curves_demo, datenum('12/05/2005'), 2^18, [1 1 1 1], [1 1 1], 0, theta_P_demo, 1);

h = msgbox({'Determined decomposition of 5-year CDX index and tranche spreads.' '' 'Press OK to continue.'}, 'Step 3', 'none');
uiwait(h);


disp('****************************************************************************************')
disp('* Demonstrating portfolio loss decomposition for 12/5/2005 (takes a couple of seconds) *')
disp('****************************************************************************************')
disp(' ')

[tranche_fractions, index_fractions, frac_average, frac_min, frac_max, frac_std, idx_frac_average, idx_frac_std] = ...
        table_tranche_spread_decomp(cdx_demo, discount_curves_demo, 2^18, [1 1 1 1], [1 1 1], 0, theta_P_demo, 1, 2);

% Generate nice output
frac_avg = [frac_average; sum(frac_average)];
frac_avg = [frac_avg sum(frac_avg, 2)];
frac_avg = num2str(round(frac_avg * 1000) / 1000);
frac_avg = ['0%-3%       3%-7%      7%-10%     10%-15%     15%-30%         Sum';
            '-----------------------------------------------------------------';
            frac_avg];
row_lables = ['Port. Loss Fract.  | ';
              '-------------------| ';
              'Expected Losses    | ';
              'Systematic Risk    | ';
              'Idiosyncratic Risk | '
              'Pure JTD Risk      | ';
              'Correlation Risk   | ';
              'Sum                | '];
table = [row_lables frac_avg];
disp(' ')
disp(table)

h = msgbox({'Determined decomposition of risk-neutral expected 5-year CDX portfolio losses.' '' 'Press OK to continue.'}, 'Step 4', 'none');
uiwait(h);



