%--------------------------------------------------------------------------------------------------
% PURPOSE:  Demonstrate: 1.) CDS spread decomposition as in Table 5 of "Risk Premia in Structured Credit Derivatives" 
%---------------------------------------------------------------------------------------------------
% USAGE: Just type 'demo4' on the Matlab command prompt and press <ENTER>
%---------------------------------------------------------------------------------------------------
% REFERENCES: "Computational Techniques for basic Affine Models of Portfolio Credit Risk", Andreas Eckner, August 2007
%             "Risk Premia in Structured Credit Derivatives", Andreas Eckner, August, 2007.
%---------------------------------------------------------------------------------------------------
% Written by Andreas Eckner, 2008
%---------------------------------------------------------------------------------------------------

disp('****************************************')
disp('* Demonstrate CDS spread decomposition *')
disp('****************************************')
disp(' ')

% Create artifical CDS, CDX index and CDX tranche dataset
if (~exist('cdx_demo'))
    create_cdx_demo2;
end

% Define vector describing physical intensity dynamics, THETA = [k,L,mu].
% See Section 5.1 in "Risk Premia in Structured Credit Derivatives". This
% parameter vector is obtained by fitting the time series of physical
% default intensities. Since the maximum likelihood estimation uses some
% proprietary data sources, I can only share the fitted parameter vector,
% but not the intermediate results.
theta_P = [3.7301 1.8634 0.0011];

% Do CDS spread decomposition for 17th company (Remark: works for any other
% company too, but companies are identical in this demo)
cds_spread_decomposition(17, cdx_demo, discount_curves_demo, datenum('12/05/2005'), [1 1 1 1], 0, theta_P, 1)