function CDX = fit_liq_prem_tranches2(CDX, discounts_IMM, start_date_num, end_date_num,  N, maturities_cds, maturities_tranches, RMSE_method, LGD_method, ...
                                     method5, method2, CDX2)
% --------------------------------------------------------------------------------------------------
% Fit the liquidity premium of tranches vs. index
% --------------------------------------------------------------------------------------------------
% CDX                           ... credit index structure (see 'all_steps_in_a_row.m')
% discounts_IMM                 ... structure with discount curves matching IMM dates
% start_date_num                ... datenum of start date
% end_date_num                  ... datenum of end date
% N                             ... number of points for numerical integration of Fourier transform
% maturities_cds                ... which maturities to fit for CDS prices, default: all
% maturities_tranches           ... which maturities to fit for tranche prices, default: all
% RMSE_method                   ... which definition of pricing error to use
% LGD_method                    ... method for (joint) distribution of LGDs
% method5                       ... which definition to use for the 5th parameters
%                                   'mu' = expected jump size \mu (default)
%                                   'mu*L' = jump intensity x jump size
% method2                       ... which definition to use for the 2nd parameter
%                               ... 'thet' = theta_total
%                               ... 'thet*k' = theta_total * k
% CDX2                          ... second CDX structure for robust RMSE calculation (optional)
% --------------------------------------------------------------------------------------------------
% sample call: fit_liq_prem_tranches2(cdx_mor, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 20000, [1 0 0 1], [1 0 0], 1, 0, ...)
% --------------------------------------------------------------------------------------------------

if (nargin <= 11)
    CDX2 = [];
end

% Determine relevant date range
start_pos = find(CDX.dates{1} >= start_date_num, 1, 'first');
end_pos = find(CDX.dates{1} <= end_date_num, 1, 'last');
used_range = start_pos:end_pos;
used_dates = CDX.dates{1}(used_range);
lower = repmat(-0.15, length(used_range), 1);
upper = repmat(0.05, length(used_range), 1);

while (max(upper - lower) > 1e-6)
    % Calculate mispricing in the middle of search interval
    middle = (lower + upper) / 2;
    liq_error = wrapper_liq_tranche_mispricing(middle, CDX, discounts_IMM, start_date_num, end_date_num, N, maturities_cds, maturities_tranches, ...
                                               RMSE_method, LGD_method, method5, method2, CDX2);        
    
    % Narrow down search interval
    positive = (liq_error > 0);
    lower(~positive) = middle(~positive);
    upper(positive) = middle(positive);
end

% Update CDX with new parameters - for dates where no index price available, use 0 liq_prem
middle = (lower + upper) / 2;
CDX.liq_prem_tranches(used_range) = middle;
[rmse, CDX] = wrapper_tranche_mispricing(get_x0(CDX, used_dates, method5, method2), CDX, discounts_IMM, start_date_num, end_date_num, N, ...
                                         maturities_cds, maturities_tranches, RMSE_method, LGD_method, 2, method5, method2, CDX2);
CDX = update_model_price_index(CDX, discounts_IMM, maturities_tranches, start_date_num, end_date_num);    

