function CDX = fit_model_cds_portfolio(CDX, discounts_IMM, start_date_num, end_date_num, maturities_cds)
% --------------------------------------------------------------------------------------------------
% Fit firm-specific model dynamics for each CDS in the index between start_date_num and end_date_num
% --------------------------------------------------------------------------------------------------
% CDX                           ... credit index structure (see 'all_steps_in_a_row.m')
% discounts_IMM                 ... structure with discount curves matching IMM dates
% start_date_num                ... datenum of start date
% end_date_num                  ... datenum of end date
% maturities_cds                ... which maturities to fit for CDS prices
% --------------------------------------------------------------------------------------------------
% sample call: fit_model_cds_portfolio(cdx_new, discounts_IMM, datenum('02/01/2006'), datenum('02/01/2006'), [1 0 0 0])
% --------------------------------------------------------------------------------------------------

% Update fit of individual CDS
start_pos = find(CDX.dates{1} >= start_date_num, 1, 'first');
end_pos = find(CDX.dates{1} <= end_date_num, 1, 'last');
used_pos = start_pos:end_pos;
used_dates = CDX.dates{1}(used_pos);
used_cds = find(sum(CDX.index_members,1) > 0);    % only update CDS that are at least once in the index

% For each CDS, extract time series of 5-yr CDS spread divided by average 5-yr CDS spread (only index members)
if (1)
    [trash, trash, trash, trash, CDS_5yr] = get_portfolio_parameters(CDX, start_date_num, end_date_num);
    avg_spread = zeros(size(CDS_5yr, 1), 1);
    for i=1:length(avg_spread)
        use_cds_t = find(CDX.index_members(used_pos(i),:) > 0);
        used_spreads = CDS_5yr(i, use_cds_t);
        avg_spread(i) = mean(used_spreads(used_spreads > 0));
    end
    ai_new = CDS_5yr ./ repmat(avg_spread, 1, size(CDS_5yr, 2));
end 

% Update CDS fit
for j=1:length(used_cds)
    i = used_cds(j);
    if (sum(maturities_cds)>1) & (mod(i,25) ==0) & (end_date_num > start_date_num)
        %disp([num2str(round(j/length(used_cds)*100)) ' %'])
    end
    if (0)
        cds_fitted = fit_model_cds5(CDX.portfolio(i), discounts_IMM, CDX, start_date_num, end_date_num, maturities_cds);
    else
        % Determine date-range used by CDS
        cds_fitted = CDX.portfolio(i);
        start_pos_cds = find(cds_fitted.dates{1} >= start_date_num, 1, 'first');
        end_pos_cds = find(cds_fitted.dates{1} <= end_date_num, 1, 'last');
        used_range_cds = start_pos_cds:end_pos_cds;
        
        % Set ai values and update fit
        cds_fitted = set_ai(cds_fitted, ai_new(:,i), used_dates);
        if (~isfield(cds_fitted, 'bi')) | (isempty(cds_fitted.bi))
            cds_fitted.bi = ones(max(1, length(cds_fitted.dates{1})), 1);
        end
        [trash, cds_fitted] = wrapper_CDS_mispricing3(cds_fitted.ai(used_range_cds,:), cds_fitted, CDX, discounts_IMM, start_date_num, end_date_num, maturities_cds);
        %cds_fitted = update_model_x0_v2(cds_fitted, discounts_IMM, CDX, start_date_num, end_date_num, 1);
    end
    CDX.portfolio(i).ai = cds_fitted.ai;
    CDX.portfolio(i).bi = cds_fitted.bi;
    CDX.portfolio(i).x0 = cds_fitted.x0;
    CDX.portfolio(i).AJD = cds_fitted.AJD;
    CDX.portfolio(i).model_price = cds_fitted.model_price;
end
%CDX = normalize_ai(CDX);

% Determine relevant date range
start_pos = find(CDX.dates{1} >= start_date_num, 1, 'first');
end_pos = find(CDX.dates{1} <= end_date_num, 1, 'last');
used_range = start_pos:end_pos;
used_dates = CDX.dates{1}(used_range);
if (~isfield(CDX, 'rmse_avg_cds'))
    CDX.rmse_avg_cds = zeros(length(CDX.dates{1}), 1);
end

% Store average CDS RMSE at each point in time (only use CDS in index)
counts = zeros(length(used_dates), 1);
total_rmse = zeros(length(used_dates), 1);
rmse_5yr = zeros(length(used_dates), 1);
for i=1:length(CDX.portfolio)
    % Calculate time series of RMSE
    [rmse, cds_new] = RMSE_CDS_mispricing(CDX.portfolio(i), start_date_num, end_date_num, maturities_cds);
    [trash, cds_new2] = RMSE_CDS_mispricing(CDX.portfolio(i), start_date_num, end_date_num, [1 0 0 0]);
    
    % Determine dates where CDS is index member & data available
    index_dates = CDX.dates{1}(logical(CDX.index_members(:,i)));
    [trash, trash2, pos_cds, pos_rmse] = intersect_triple(index_dates, cds_new.dates{1}, used_dates);
    if isempty(pos_cds)
        continue;
    end
    
    % Add RMSE for dates found
    counts(pos_rmse) = counts(pos_rmse) + 1;
    total_rmse(pos_rmse) = total_rmse(pos_rmse) + min(cds_new.rmse(pos_cds), 2);    % Cap RMSE at 2  
    rmse_5yr(pos_rmse) = rmse_5yr(pos_rmse) + min(cds_new2.rmse(pos_cds), 2);    % Cap RMSE at 2
end
CDX.rmse_avg_cds(used_range,:) = total_rmse ./ counts;
CDX.rmse_5yr_cds(used_range,:) = rmse_5yr ./ counts;



