function [discounts2, discounts_inbetween2] = get_discounts(date_nums, discounts, T_max)
% --------------------------------------------------------------------------------------------------
% Get discount curves for a selection of dates
% --------------------------------------------------------------------------------------------------
% date_nums ... date_nums for which discount curves are required
% T_max     ... maximum horizon required for each date
% discounts ... structure with all discount curves
% --------------------------------------------------------------------------------------------------
% sample call: get_discounts(datenum({'11/20/2006'; '11/21/2006'}), discounts_IMM, 5)
% --------------------------------------------------------------------------------------------------

% Determine relevant rows
all_dates = discounts.dates;
[trash, rows] = is_member_sorted_c(date_nums, all_dates);

% Check if discount curves are available for all dates where there is a CDS price
if (is_member_sorted_c(0, rows))
   %disp('Warning: Some discount curves not available - use most recent one instead');
   rows(rows == 0) = max(rows);
end

% Return desired discount curves
T_max = ceil(max(T_max)*4);
discounts2 = discounts.discounts(rows, 1:T_max);
discounts_inbetween2 = discounts.discounts_inbetween(rows, 1:T_max);