function CDX = bump_lambda(CDX, date, bump_size)
% --------------------------------------------------------------------------------------------------
% Helper function; bump initial todal default intensity for all CDS in the portfolio. The bump is
% distributed proportionally between the idiosyncratic and systematic part, according to the ratio
% of these intensities.
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure
% date              ... date for bumping
% bump_size         ... size of bump
% --------------------------------------------------------------------------------------------------
% sample call: bump_lambda(cdx_mor, '12/05/2005', 1e-4)
% --------------------------------------------------------------------------------------------------

% Extract ratio y0 / Avg(lambda_it)
date = datenum(date);
date_pos = find(CDX.dates{1} == date);
y0 = CDX.y0(date_pos);
lambda_it = get_x_it(CDX, date);
ratio = y0 / mean(lambda_it);

% Do the bumping
CDX.y0(date_pos) = CDX.y0(date_pos) + bump_size * ratio;
for i=1:length(CDX.portfolio)
    % Bump initial idiosyncratic intensity of i-th CDS by one basis point
    cds = CDX.portfolio(i);
    pos = find(cds.dates{1} == date);
    if isempty(pos)
        continue;
    end
    cds.x0(pos) = cds.x0(pos) + bump_size;
    CDX.portfolio(i) = cds;
end