function CDX = bump_lambda_process_i(CDX, date, bump_size, i)
% --------------------------------------------------------------------------------------------------
% Helper function; bump the i-th default intensity processes, i.e. multiply by a factor
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure
% date              ... date for bumping
% bump_size         ... size of bump
% i                 ... which CDS to bump
% --------------------------------------------------------------------------------------------------
% sample call: bump_lambda_process_i(cdx_mor, '12/05/2005', 1e-4)
% --------------------------------------------------------------------------------------------------

% Also scale up dynamics of idiosyncratic factor
factor = 1 + bump_size;
cds = CDX.portfolio(i);
cds.ai = cds.ai * factor;
AJD = cds.AJD;
AJD.theta = AJD.theta * factor;
AJD.sigma = AJD.sigma * sqrt(factor);
AJD.mu = AJD.mu * factor;
cds.AJD = AJD;

% Bump initial idiosyncratic intensity of i-th CDS
pos = find(cds.dates{1} == date);
if (~isempty(pos))
    cds.x0(pos) = cds.x0(pos) * factor;
end
CDX.portfolio(i) = cds;
