function CDX = bump_lambda_processes(CDX, date, bump_size)
% --------------------------------------------------------------------------------------------------
% Helper function; bump all default intensity processes, i.e. multiply by a factor
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure
% date              ... date for bumping
% bump_size         ... size of bump
% --------------------------------------------------------------------------------------------------
% sample call: bump_x0(cdx_mor, '12/05/2005', 1e-4)
% --------------------------------------------------------------------------------------------------

% Do the bumping
factor = 1 + bump_size;
CDX.liq_prem_cds = CDX.liq_prem_cds * factor;
CDX.liq_prem_tranches = CDX.liq_prem_tranches * factor;
for i=1:length(CDX.portfolio)
    % Also scale up dynamics of idiosyncratic factor
    cds = CDX.portfolio(i);
    cds.ai = cds.ai * factor;
    AJD = cds.AJD;
    AJD.theta = AJD.theta * factor;
    AJD.sigma = AJD.sigma * sqrt(factor);
    AJD.mu = AJD.mu * factor;
    cds.AJD = AJD;
    
    % Bump initial idiosyncratic intensity of i-th CDS
    pos = find(cds.dates{1} == date);
    if isempty(pos)
        continue;
    end
    cds.x0(pos) = cds.x0(pos) * factor;
    
    CDX.portfolio(i) = cds;
end