function CDX = bump_mu(CDX, date, bump_size)
% --------------------------------------------------------------------------------------------------
% Helper function; bump jump size
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure
% date              ... date for bumping
% bump_size         ... size of bump
% --------------------------------------------------------------------------------------------------
% sample call: bump_mu(cdx_mor, '12/05/2005', 1e-3)
% --------------------------------------------------------------------------------------------------

% Do the bumping
CDX.AJD_common_factor.mu = CDX.AJD_common_factor.mu + bump_size;
for i=1:length(CDX.portfolio)
    % Bump mu_i by bump_size*ai
    cds = CDX.portfolio(i);
    cds.AJD.mu = cds.AJD.mu + cds.ai*bump_size;
    CDX.portfolio(i) = cds;
end