function CDX = bump_x0(CDX, date, bump_size)
% --------------------------------------------------------------------------------------------------
% Helper function; bump initial idiosyncratic default intensity for all CDS in the portfolio
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure
% date              ... date for bumping
% bump_size         ... size of bump
% --------------------------------------------------------------------------------------------------
% sample call: bump_x0(cdx_mor, '12/05/2005', 1e-4)
% --------------------------------------------------------------------------------------------------

% Do the bumping
for i=1:length(CDX.portfolio)
    % Bump initial idiosyncratic intensity of i-th CDS by one basis point
    cds = cdx_tmp.portfolio(i);
    pos = find(cds.dates{1} == date);
    if isempty(pos)
        continue;
    end
    cds.x0(pos) = cds.x0(pos) + bump_size;
    CDX.portfolio(i) = cds;
end