function CDX = bump_x0_i(CDX, date, bump_size, i)
% --------------------------------------------------------------------------------------------------
% Helper function; bump initial idiosyncratic default intensity for i-th CDS in portfolio
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure
% date              ... date for bumping
% bump_size         ... size of bump
% i                 ... which CDS to bump
% --------------------------------------------------------------------------------------------------
% sample call: bump_x0(cdx_mor, '12/05/2005', 1e-4, i)
% --------------------------------------------------------------------------------------------------

% Do the bumping
factor = 1 + bump_size;
cds = CDX.portfolio(i);
pos = find(cds.dates{1} == date);
if isempty(pos)
    return;
end
cds.x0(pos) = cds.x0(pos) * factor;
CDX.portfolio(i) = cds;
