function CDX = bump_y0(CDX, date, bump_size)
% --------------------------------------------------------------------------------------------------
% Helper function; bump initial systematic default intensity
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure
% date              ... date for bumping
% bump_size         ... size of bump
% --------------------------------------------------------------------------------------------------
% sample call: bump_x0(cdx_mor, '12/05/2005', 1e-4)
% --------------------------------------------------------------------------------------------------

% Do the bumping
date = datenum(date);
date_pos = find(CDX.dates{1} == date);
CDX.y0(date_pos) = CDX.y0(date_pos) + bump_size;
for i=1:length(CDX.portfolio)
    % Bump initial intensity of i-th CDS (to keep idiosyncratic part constant)
    cds = CDX.portfolio(i);
    pos = find(cds.dates{1} == date);
    if isempty(pos)
        continue;
    end
    cds.x0(pos) = cds.x0(pos) + cds.ai*bump_size;
    
    CDX.portfolio(i) = cds;
end