function tranche_deltas_gamma_syst(CDX, date, discounts_IMM, N)
% --------------------------------------------------------------------------------------------------
% Calculate tranche deltas and gammas for changes in (i) systematic factor, (ii) Avg(lambda_it)
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure
% date              ... date for which to calculate tranche deltas and gammas
% discounts_IMM     ... structure with discount curves matching IMM dates
% N                 ... number of points for numerical integration of Fourier transform
% --------------------------------------------------------------------------------------------------
% sample call: tranche_deltas_gamma_syst(cdx_mor, '12/05/2005', discounts_IMM, 2^17)
%              tranche_deltas_gamma_syst(cdx_mor, '12/05/2005', discounts_IMM, 2^17)
% --------------------------------------------------------------------------------------------------

% Determine used date position
date = datenum(date);
date_pos = find(CDX.dates{1} == date);

% Calculate tranche and index prices with orignal parameters
cdx_tmp = update_model_price_tranches(CDX, discounts_IMM, N, date, date, [1 0 0], 0, 2);
tranche_prices_orig = [cdx_tmp.tranche_model_upfront{1}(date_pos,1) cdx_tmp.tranche_model_price{1}(date_pos,2:end)]; 
cdx_tmp = update_model_price_index(CDX, discounts_IMM, [1 1 1], date, date);
index_price_orig = cdx_tmp.index_model_price{1}(date_pos);

% Calculate delta_lambda_process
if (1)
    bump_size = 1e-1;
    cdx_tmp = bump_lambda_processes(CDX, date, bump_size);
    cdx_tmp = update_model_price_tranches(cdx_tmp, discounts_IMM, N, date, date, [1 0 0], 0, 2);
    tranche_prices_new = [cdx_tmp.tranche_model_upfront{1}(date_pos,1) cdx_tmp.tranche_model_price{1}(date_pos,2:end)];
    tranche_change_lambda2 = (tranche_prices_new - tranche_prices_orig) / bump_size;
    cdx_tmp = update_model_price_index(cdx_tmp, discounts_IMM, [1 1 1], date, date);
    index_price_new = cdx_tmp.index_model_price{1}(date_pos);
    index_change_lambda2 = (index_price_new - index_price_orig) / bump_size;
    delta_lambda2 = tranche_change_lambda2 / index_change_lambda2;
    delta_lambda2(1) = delta_lambda2(1) * 1e4 / 4.7;
    disp(['Delta_lambda_processes: ' num2str(delta_lambda2)]);
end

% Calculate delta_mu
if (1)
bump_size = 1e-2;
    cdx_tmp = bump_mu(CDX, date, bump_size);
    cdx_tmp = update_model_price_tranches(cdx_tmp, discounts_IMM, N, date, date, [1 0 0], 0, 2);
    tranche_prices_new = [cdx_tmp.tranche_model_upfront{1}(date_pos,1) cdx_tmp.tranche_model_price{1}(date_pos,2:end)];
    tranche_change = (tranche_prices_new - tranche_prices_orig) / bump_size;
    cdx_tmp = update_model_price_index(cdx_tmp, discounts_IMM, [1 1 1], date, date);
    index_price_new = cdx_tmp.index_model_price{1}(date_pos);
    index_change = (index_price_new - index_price_orig) / bump_size;
    delta_mu = tranche_change/ index_change;
    delta_mu(1) = delta_mu(1) * 1e4 / 4.7;
    disp(['Delta_mu: ' num2str(delta_mu)]);
end

% Calculate delta_y
if (1)
    bump_size = 1e-3;
    cdx_tmp = bump_y0(CDX, date, bump_size);
    cdx_tmp = update_model_price_tranches(cdx_tmp, discounts_IMM, N, date, date, [1 0 0], 0, 2);
    tranche_prices_new = [cdx_tmp.tranche_model_upfront{1}(date_pos,1) cdx_tmp.tranche_model_price{1}(date_pos,2:end)];
    tranche_change_y = (tranche_prices_new - tranche_prices_orig) / bump_size;
    cdx_tmp = update_model_price_index(cdx_tmp, discounts_IMM, [1 1 1], date, date);
    index_price_new = cdx_tmp.index_model_price{1}(date_pos);
    index_change_y = (index_price_new - index_price_orig) / bump_size;
    delta_y = tranche_change_y / index_change_y;
    delta_y(1) = delta_y(1) * 1e4 / 4.7;
    disp(['Delta_y: ' num2str(delta_y)]);
end

% Calculate delta_lambda
if (1)
    cdx_tmp = bump_lambda(CDX, date, bump_size);
    cdx_tmp = update_model_price_tranches(cdx_tmp, discounts_IMM, N, date, date, [1 0 0], 0, 2);
    tranche_prices_new = [cdx_tmp.tranche_model_upfront{1}(date_pos,1) cdx_tmp.tranche_model_price{1}(date_pos,2:end)];
    tranche_change_lambda = (tranche_prices_new - tranche_prices_orig) / bump_size;
    cdx_tmp = update_model_price_index(cdx_tmp, discounts_IMM, [1 1 1], date, date);
    index_price_new = cdx_tmp.index_model_price{1}(date_pos);
    index_change_lambda = (index_price_new - index_price_orig) / bump_size;
    delta_lambda = tranche_change_lambda / index_change_lambda;
    delta_lambda(1) = delta_lambda(1) * 1e4 / 4.7;
    disp(['Delta_lambda0: ' num2str(delta_lambda)]);
end

% Extract average market price
cds_prices = [];
for i=1:length(CDX.portfolio)   % Extract CDS prices & x_it at time 0
    cds = CDX.portfolio(i);
    if (~isempty(cds.market_price{1}))
        cds_prices(i) = cds.market_price{1}(date_pos);
    end
end
avg_cds_5yr = mean(cds_prices(cds_prices>0));

% % Make nice table
% cds_prices = zeros(num_cds, 1);
% x0 = zeros(num_cds, 1);
% y_syst = zeros(num_cds, 1);
% for i=1:length(CDX.portfolio)   % Extract CDS prices & x_it at time 0
%     cds = CDX.portfolio(i);
%     if (~isempty(cds.market_price{1}))
%         cds_prices(i) = cds.market_price{1}(date_pos);
%         x0(i) = (cds.x0(date_pos) - y0 * cds.ai) * 1e4;
%         y_syst(i) = y0 * cds.ai * 1e4;
%     end
% end
% table = [cds_prices x0 y_syst delta_matrix];


