function cds = CDS_TS_update_vol(cds, method, param)
% --------------------------------------------------------------------------------------------------
% Add volatility time series of CDS spread changes to CDS structure,  using data only up
% to time t-1 for time t estimate.
% --------------------------------------------------------------------------------------------------
% cds       ... credit default swap structure
% method    ... 1 = moving average of length 'param'
%               2 = exponentially weighted moving average with decay factor 'param', e.g. 0.95
%               3 = robust estimator based on medium of squared returns during last 'param' days
% --------------------------------------------------------------------------------------------------
% sample call: CDS_TS_update_vol(CDX_NA_IG2.portfolio(1), 1, 40)
%              CDS_TS_update_vol(CDX_NA_IG2.portfolio(1), 2, 0.975)
%              CDS_TS_update_vol(CDX_NA_IG2.portfolio(1), 3, 40)
% --------------------------------------------------------------------------------------------------

vol_TS = TS_price_to_vol(cds.market_price{1}, cds.dates{1}, method, param);
cds.vol_TS = struct('vol', [vol_TS.vol(1); vol_TS.vol], 'delta_t', [vol_TS.delta_t(1); vol_TS.delta_t]);