function CDX = CDX_TS_update_vol(CDX, method, param)
% --------------------------------------------------------------------------------------------------
% For each CDS in CDX, ddd volatility time series of CDS spread changes to CDS structure, using data
% only up to time t-1 for time t estimate.
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure
% method    ... 1 = moving average of length 'param'
%               2 = exponentially weighted moving average with decay factor 'param', e.g. 0.95
%               3 = robust estimator based on medium of squared returns during last 'param' days
% --------------------------------------------------------------------------------------------------
% sample call: CDX_TS_update_vol(CDX_NA_IG2_monthly, 3, 40)
% --------------------------------------------------------------------------------------------------

for i=1:length(CDX.portfolio)
    % Update volatility time series
    cds = CDX.portfolio(i);
    %disp(i);
    cds = CDS_TS_update_vol(cds, method, param);
    if (i == 1)
        portfolio_new = cds;
    else
        portfolio_new(i) = cds;
    end
end
CDX.portfolio = portfolio_new;