function vols = CDX_get_vols(CDX, tickers, date)
% --------------------------------------------------------------------------------------------------
% Return volatility for list of companies on a certain date (-1 if not found).
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure
% tickers   ... list of companies for which to return volatility
% date      ... date for which to return volatility
% --------------------------------------------------------------------------------------------------
% sample call: CDX_get_vols(CDX_NA_IG2, tickers, '12/05/2005')
% --------------------------------------------------------------------------------------------------

% Determine used tickers
date = datenum(date);
all_tickers = {CDX.portfolio.ticker}';
vols = zeros(length(tickers), 1);
for i=1:length(tickers)
    match = find(strcmp(all_tickers, tickers(i)));
    if (~isempty(match))
        % Determine position of matching (or last available) date
        cds = CDX.portfolio(match);
        date_pos = find(cds.dates{1} <= date, 1, 'last');
        if (isempty(date_pos))
            vols(i) = -1;
            continue;
        end
        cds_date = cds.dates{1}(date_pos);
        
        % Only use data if less than 7 days old
        if (daysact(cds_date, date) >= 7)
            vols(i) = -1;
            continue;
        end
        vols(i) = cds.vol_TS.vol(date_pos);
    else
        vols(i) = -1;
    end
end
