function vols = CDX_get_vols_model(CDX, tickers, date, type)
% --------------------------------------------------------------------------------------------------
% Return model-implied volatility for list of companies on a certain date (-1 if not found).
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure
% tickers   ... list of companies for which to return volatility
% date      ... date for which to return volatility
% type      ... type of model-implied volatility to calculate:
%               1 ... diffusive volatility
%               2 ... total volatility (includes jumps)
% --------------------------------------------------------------------------------------------------
% sample call: CDX_get_vols_model(CDX_NA_IG2, tickers, '12/05/2005')
% --------------------------------------------------------------------------------------------------

% Determine used tickers
date = datenum(date);
all_tickers = {CDX.portfolio.ticker}';
pos = zeros(length(tickers), 1);
for i=1:length(tickers)
    match = find(strcmp(all_tickers, tickers(i)));
    if (~isempty(match))
        pos(i) = match;
    end
end

% Extract instantaneous firm-specific default intensities & volatilities
lambda_it = zeros(length(pos), 1);
sigma = zeros(length(pos), 1);
mu = zeros(length(pos), 1);
L = zeros(length(pos), 1);
for i=1:length(pos)
    % Determine position of matching (or last available) date
    cds = CDX.portfolio(pos(i));
    date_pos = find(cds.dates{1} <= date, 1, 'last');
    if (isempty(date_pos))
        lambda_it(i) = -1;
    else
    	lambda_it(i) = cds.market_price{1}(date_pos);
        sigma(i) = cds.AJD.sigma;
        mu(i) = cds.AJD.mu;
        L(i) = cds.AJD.L;
    end
end

% Calculate model-implied (diffusive) volatility
if (type == 1)
    vols = (lambda_it > 0) .* sigma ./ sqrt(lambda_it/1e4) - (lambda_it <= 0);
end
if (type == 2)
     vols = (lambda_it > 0) .* sqrt(sigma.^2 + mu.^2 .* L) ./ sqrt(lambda_it/1e4) - (lambda_it <= 0);
end

