function CDX = CDX_insert_a_b_P(CDX, TS_Y, TS_omega4)
% --------------------------------------------------------------------------------------------------
% Calculate time series of a_it^P and b_it^P and merge with CDX structure
% --------------------------------------------------------------------------------------------------
% CDX           ... credit index structure
% TS_Y          ... time series of common factor
% TS_omega4     ... time series of a_it^P / lambda_it^P
% --------------------------------------------------------------------------------------------------
% sample call: CDX_insert_a_b_P(cdx_tv_monthly10, TS_Y10, TS_omega4);
% --------------------------------------------------------------------------------------------------

for i=1:length(CDX.portfolio)
    cds = CDX.portfolio(i);
    if isempty(cds.intensity_P)
        cds.ai_P = [];
        cds.bi_P = [];
    else
        % Calculate a_it_P
        TS_X_it = struct('dates', cds.dates{1}, 'values', cds.x0);
        TS_a_it_Q = struct('dates', cds.dates{1}, 'values', cds.ai);
        TS_lambda_P = struct('dates', cds.dates{1}, 'values', cds.intensity_P);
        TS_a_it = TS_mult_TS(TS_lambda_P, TS_omega4);
        
        % Calculate b_it_P
        TS_lambda_it_Q = TS_add_TS(TS_X_it, TS_mult_TS(TS_a_it_Q, TS_Y));  
        if (0)
            % Introduce floor of 1bps for X_it to catch outlieres
            TS_X_it = TS_max_TS(TS_X_it, TS_const(1e-4, TS_X_it.dates(1)));
        end
        TS_b_it = TS_divide_TS(TS_minus_TS(TS_lambda_P, TS_mult_TS(TS_a_it, TS_Y)), TS_X_it);
        
        % Remove outliers
        if (0)
            % Cap a_it_P at 100 times a_it_Q to catch outliers
            TS_a_it = TS_min_ts(TS_a_it, TS_mult_TS(TS_a_it_Q, TS_const(100, TS_X_it.dates(1))));
            % Cap b_it_Q / b_it_P at 100 to catch outliers
            TS_b_it = TS_min_TS(TS_b_it, TS_const(100, TS_X_it.dates(1))); 
        else
            % Cap a_it_P at 100 times a_it_Q to catch outliers
            TS_a_it = TS_min_ts(TS_a_it, TS_mult_TS(TS_a_it_Q, TS_const(100, TS_X_it.dates(1))));
            
            % Replace b_it_P values >= 5 with median{b_it_P: b_it_Q / b_it_P < 5}
            large = (TS_b_it.values >= 5);
            tmp = TS_b_it.values(~large);            
            normal = median(tmp(~isnan(tmp)));
            TS_b_it.values(large) = normal;
        end
        
        % Replace INFs with most recently available value
        not_inf = find(~isinf(TS_b_it.values));
        used_pos = previous_pos_c(not_inf, 1:length(TS_b_it.values));
        used_pos = not_inf(used_pos);
        TS_b_it.values = TS_b_it.values(used_pos);
        
        % Various plots
        if (0)
            TS_plot(TS_lambda_P)
            TS_plot(TS_X_it)
            TS_plot(TS_lambda_it_Q)
            
            TS_plot(TS_a_it)
            TS_plot(TS_a_it_Q)
            TS_plot(TS_mult_TS(TS_a_it_Q, TS_Y))
            TS_plot(TS_b_it)
            TS_plot(TS_mult_TS(TS_b_it, TS_X_it))                       
        end
        
        % Insert fields into cds
        TS_a_it = TS_sample(TS_a_it, cds.dates{1});
        TS_b_it = TS_sample(TS_b_it, cds.dates{1});
        cds.ai_P = TS_a_it.values;
        cds.bi_P = TS_b_it.values;
    end
    
    % Save cds portfolio
    if (i == 1)
        portfolio = cds;
    else
        portfolio(i) = cds;
    end
end
CDX.portfolio = portfolio;