function CDX = CDX_merge_D_it(CDX, TS_a, TS_Y)
% --------------------------------------------------------------------------------------------------
% Calculate time series D_it = b_it * X_it and merge with CDX structure
% --------------------------------------------------------------------------------------------------
% CDX           ... credit index structure
% TS_a          ... time series of a_it^P, i.e. loading on common factor under P
% TS_Y          ... time series of common factor
% --------------------------------------------------------------------------------------------------
% sample call: CDX_merge_D_it(CDX, TS_vector_ev, TS_Y);
% --------------------------------------------------------------------------------------------------

for i=1:length(CDX.portfolio)
    cds = CDX.portfolio(i);
    if isempty(cds.intensity_P)
        cds.D_it = [];
    else
        % Calculate D_it for i-th company
        TS_lambda_P = struct('dates', cds.dates{1}, 'values', cds.intensity_P);
        D_it = TS_minus_TS(TS_lambda_P, TS_mult_TS(TS_a{i}, TS_Y));

        % Check that D_it is non-negative
        if (min(D_it.values) < 0)
            test=1;
        end
    end
    
    % Save cds portfolio
    if (i == 1)
        portfolio = cds;
    else
        portfolio(i) = cds;
    end
end
CDX.portfolio = portfolio;