function [F_ineq, F_eq] = Feller(x0, trash, trash2)
% --------------------------------------------------------------------------------------------------
% Return k*theta-sigma^2/2, that is, a negative number if and only if the Feller condition for CIR
% process is violated.
% --------------------------------------------------------------------------------------------------
% x0    ... vector of parameters [k, theta, sigma]
% --------------------------------------------------------------------------------------------------
% sample call: Feller([1 1 2])
% --------------------------------------------------------------------------------------------------

F_ineq = x0(3)^2/2 - x0(1)*x0(2);
F_eq = 0;