function data = add_CDX_DTD(CDX)
% --------------------------------------------------------------------------------------------------
% Add DTD to CDX portfolio
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% --------------------------------------------------------------------------------------------------
% sample call: import_compustat('c:/thesis/data/compustat/stocks cdx.xls')
% --------------------------------------------------------------------------------------------------

% Import data
[num, txt] = xlsread(file_name, 1);

% Extract relevant columns
tickers = txt(2:end,1);
clear txt;
data12 = num(:,2);
data13 = num(:,3);
data14 = num(:,4);
data45 = num(:,5);
data49 = num(:,6);
data51 = num(:,7);
data61 = num(:,8);
year = num(:,11);
quarter = num(:,12);

% Sequentially process data for each company
unique_tickers = unique(tickers);
for i=1:length(unique_tickers)
    ticker = unique_tickers{i};
    used_rows = find(strcmp(ticker, tickers));
    
    % Generate time series object for covariates
    covariates = struct('ticker', ticker, 'dates', {[]}, 'share_price', {[]}, ...
                        'shares', {[]}, 'mcap', {[]}, 'st_debt', {[]}, 'lt_debt', {[]});
    
    % Insert data into time series of covariates
    for j=1:length(used_rows)
        % Determine st_debt
        avail45 = ~isnan(data45(used_rows(j)));
        avail49 = ~isnan(data49(used_rows(j)));
        if (avail45 & avail49)
            st_debt = max(data45(used_rows(j)), data49(used_rows(j)));
        elseif (avail45 & (~avail49))
            st_debt = data45(used_rows(j));
        elseif ((~avail45) & avail49)
            st_debt = data49(used_rows(j));
        else
            continue
        end
        
        % Determine lt_debt
        avail51 = ~isnan(data51(used_rows(j)));
        if (avail51)
            lt_debt = data51(used_rows(j));
        else
            continue;
        end
        
        % Determine shares outstanding
        avail61 = ~isnan(data61(used_rows(j)));
        if (avail61)
            shares_outstanding = data61(used_rows(j));
        else
            continue;
        end       
        
        % Determine share price
        avail12 = ~isnan(data12(used_rows(j)));
        avail13 = ~isnan(data13(used_rows(j)));
        avail14 = ~isnan(data14(used_rows(j)));
        if (avail12)
            price = data12(used_rows(j));
        elseif (avail13)
            price = data13(used_rows(j));
        elseif (avail14)
            price = data14(used_rows(j));
        else
            continue
        end
        
        % Determine date
        date = datenum(year(used_rows(j)), (quarter(used_rows(j))-1)*3 + 1, 1);
        
        % Insert data into time series object
        insert_pos = find([0; covariates.dates] <= date, 1, 'last');
        covariates.dates = [covariates.dates(1:(insert_pos-1)); date; covariates.dates(insert_pos:end)];
        covariates.st_debt = [covariates.st_debt(1:(insert_pos-1)); st_debt; covariates.st_debt(insert_pos:end)];
        covariates.lt_debt = [covariates.lt_debt(1:(insert_pos-1)); lt_debt; covariates.lt_debt(insert_pos:end)];
        covariates.share_price = [covariates.share_price(1:(insert_pos-1)); price; covariates.share_price(insert_pos:end)];
        covariates.shares = [covariates.shares(1:(insert_pos-1)); shares_outstanding; covariates.shares(insert_pos:end)];
        covariates.mcap = [covariates.mcap(1:(insert_pos-1)); price*shares_outstanding/1e3; covariates.mcap(insert_pos:end)];
    end
    if (i==1)
        data = covariates;
    else
        data(i) = covariates;
    end
end