function analyze_ai_P(CDX, TS_ai, date)
% --------------------------------------------------------------------------------------------------
% Analyze relationship between a_it^P, lambda_P and 5yr CDS spread.
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure
% TS_ai             ... TS_vector of factor loadings on common factor under P
% date              ... which date to analyze
% --------------------------------------------------------------------------------------------------
% sample call: analyze_ai_P(CDX_NA_IG2, TS_vector_ev, datenum('12/05/2005'));
% --------------------------------------------------------------------------------------------------

% Extract ai_P for index members
date_pos = find(CDX.dates{1} == date);
used_cds = find(logical(CDX.index_members(date_pos,:)));
ai_P = TS_matrix_sample1(TS_ai, date, 1:length(TS_ai), 1);
ai_P = ai_P(used_cds);

% Extract lambda_P
lambda_P = extract_cds_values(CDX, 'intensity_P', date);
lambda_P = lambda_P(used_cds);
CDS_5yr = extract_cds_values(CDX, 'market_price', date, 1);
CDS_5yr = CDS_5yr(used_cds);

% Combine data for rank correlation analysis in R
if (0)
    data = [ai_P lambda_P];
    available = (sum(isnan(data),2) == 0);
    data = data(available,:);
end

% Plot ai_P vs lambda_P
axes('YScale','log','XScale','log');
hold all
scatter(ai_P, lambda_P)
hold off
xlabel('ai')
ylabel('lambda_P')

% Plot ai_P vs 5yr CDS
axes('XScale','log');
hold all
scatter(ai_P, CDS_5yr)
hold off
xlabel('ai')
ylabel('5yr CDS')

% Plot lambda_P vs 5yr CDS
axes('YScale','log','XScale','log');
hold all
scatter(lambda_P, CDS_5yr)
hold off
xlabel('lambda_P')
ylabel('5yr CDS')
