function return1yr = calculate_1yr_return(dates, share_price)
% --------------------------------------------------------------------------------------------------
% Calculate lagged 1-year stock price return
% --------------------------------------------------------------------------------------------------
% sample call: calculate_1yr_return(CDX_NA_IG2.portfolio(1).dates{1}, CDX_NA_IG2.portfolio(1).share_price)
% --------------------------------------------------------------------------------------------------

if (isempty(share_price))
    return1yr = [];
    return;
end

% Calculate lagged dates
[Y, M, D] = datevec(dates);
lagged_dates = datenum(Y-1, M, D);

% Calculate return
lagged_pos = fuzzy_datenum_match(lagged_dates, dates);
return1yr = (share_price - share_price(lagged_pos)) ./ share_price(lagged_pos);