function CDX = calculate_lambda_P(CDX)
% --------------------------------------------------------------------------------------------------
% Calculate lambda_P as estimated in 'Frailty Correlated Default'
% --------------------------------------------------------------------------------------------------
% CDX      ... credit index structure
% --------------------------------------------------------------------------------------------------
% sample call: calculate_lambda_P(CDX_NA_IG2)
% --------------------------------------------------------------------------------------------------

% Load S&P500 return and 3m LIBOR
libor3m = import_libor_bloomberg('c:/thesis/data/bloomberg/libor3m monthly.xls');
sp500 = import_sp500_bloomberg('c:/thesis/data/bloomberg/s&p500 index monthly.xls');

for i=1:length(CDX.portfolio)
    % Extract relevant covariates
    cds = CDX.portfolio(i); 
    return1yr = calculate_1yr_return(cds.dates{1}, cds.share_price);
    cds.return1yr = return1yr;

    % Also calculate default intensity
    sp500_pos = fuzzy_datenum_match(cds.dates{1}, sp500.dates);
    libor3m_pos = fuzzy_datenum_match(cds.dates{1}, libor3m.dates);
    if (~isempty(cds.DTD))
        cds.intensity_P =  exp(-ones(size(return1yr))*2.093 - 1.2 * cds.DTD ...
                               -0.681 * cds.return1yr + 1.481 * sp500.return1yr(sp500_pos) - 0.106 * libor3m.price(libor3m_pos));   
    else
        cds.intensity_P = [];
    end
    
    % If only NaNs, the remove intensity
    if (sum(isnan(cds.intensity_P)) == length(cds.intensity_P))
        cds.intensity_P = [];
    end
    
    % Save cds portfolio
    if (i == 1)
        portfolio = cds;
    else
        portfolio(i) = cds;
    end
end
CDX.portfolio = portfolio;