% Use formula from frailty paper
CDX_NA_IG2 = calculate_lambda_P(CDX_NA_IG2);
cdx_tv_monthly = calculate_lambda_P(cdx_tv_monthly);
cdx_tv_monthly10 = calculate_lambda_P(cdx_tv_monthly10);

% Time series manipulations
cds = CDX_NA_IG2.portfolio(1);
test = TS_price_to_return(cds.market_price{1}, cds.dates{1});
cds = CDS_TS_update_vol(cds, 1, 40);
cds = CDS_TS_update_vol(cds, 2, 0.975);
cds = CDS_TS_update_vol(cds, 1, 40);
plot(cds.vol_TS.vol)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Comparative volatility analysis %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

CDX_NA_IG2 = CDX_TS_update_vol(CDX_NA_IG2, 3, 40);

% Extract individual volatilites for list of stocks on a certain date
tickers = {cdx_mor.portfolio.ticker}';
vols = CDX_get_vols(CDX_NA_IG2, tickers, '12/05/2005');
vols_model = CDX_get_vols_model(CDX_NA_IG2, tickers, '12/05/2005', 1);
vols_model2 = CDX_get_vols_model(CDX_NA_IG2, tickers, '12/05/2005', 2);
plot(vols_model(vols_model>0), vols_model2(vols_model>0))

% Make nice plots
hist(vols(vols>0));
plot_empirical_vol_vs_spread(CDX_NA_IG2, tickers, '12/05/2005', 1, @sqrt);
plot_empirical_vol_vs_spread(CDX_NA_IG2, tickers, '12/05/2005', 4, @sqrt);
plot_emprirical_vs_model_vol(vols, vols_model);
plot_emprirical_vs_model_vol(vols, vols_model2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Comparative correlation analysis %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Define time series
TS1 = struct('values', CDX_NA_IG2.portfolio(1).intensity_P, 'dates', CDX_NA_IG2.portfolio(1).dates{1});
TS2 = struct('values', CDX_NA_IG2.portfolio(2).intensity_P, 'dates', CDX_NA_IG2.portfolio(2).dates{1});
TS1_return = TS_return(TS1, 1);
TS2_return = TS_return(TS2, 1);
TS_vector = {TS1; TS2};
TS_vector_return = {TS1_return; TS2_return};

% Plotting
TS_plot(TS1);
TS_vector_plot(TS_vector)
TS_plot(TS1_return);
TS_vector_plot(TS_vector_return);

% Volatility
test = TS_volatility(TS1_return, 4, 40);
TS_plot(test);
test = TS_volatility_level(TS1, 1, 4, 40);
TS_plot(test);

% Continuous quadratic variation (via bi-power variation)
test = TS_volatility(TS1_return, 5, 40);
TS_plot(test);
test = TS_volatility_level(TS1, 1, 5, 40);
TS_plot(test);

% Covariance
test = TS_covariance_TS(TS1_return, TS2_return, 4, 40);
TS_plot(test);
test = TS_covariance_TS_level(TS1, TS2, 1, 4, 40);
TS_plot(test);

% Continuous quadratic co-variation (via bi-power variation)
test = TS_covariance_TS(TS1_return, TS2_return, 5, 40);
TS_plot(test);

% Correlation
test = TS_correlation_TS_level(TS1, TS2, 1, 4, 40);
TS_plot(test);                  
test = TS_correlation_TS(TS1_return, TS2_return, 4, 40);
TS_plot(test);     

% Covariance matrix    
test = TS_vector_covariance_level(TS_vector, 1, 4, 40);
TS_plot(test{1,2});
% test = TS_vector_covariance_level(TS_vector, 1, 2, 0.98);
% TS_plot(test{1,2});
test = TS_vector_covariance(TS_vector_levels2returns(TS_vector, 1), 4, 40);  
TS_plot(test{1,2});
       
% Continuous quadratic covariance matrix (via bi-power variation)
test = TS_vector_covariance(TS_vector_levels2returns(TS_vector, 1), 5, 40);  
TS_plot(test{1,2});

% Correlation matrix       
test = TS_vector_correlation(TS_vector_levels2returns(TS_vector, 1), 4, 40);
TS_plot(test{1,2});
% test = TS_vector_correlation_level(TS_vector, 3, 2, 0.98);
% TS_plot(test{1,2});



%%%%%%%%%%%%%%%%%
% Jump analysis %
%%%%%%%%%%%%%%%%%

test1 = TS_return(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), 3);
test2 = TS_minus_TS(TS_quadratic_variation(test1), TS_bipower_variation(test1));
TS_plot(test2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Estimation of rolling covariance matrix of lambda_P for all companies in CDX.NA.IG %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Construct time series vector
TS_lambda_P = {};
for i=1:10 %length(CDX_NA_IG2.portfolio)    
    TS = struct('values', CDX_NA_IG2.portfolio(i).intensity_P, 'dates', CDX_NA_IG2.portfolio(i).dates{1});
    if isempty(TS.values)
        TS.dates = [];
    end
    TS_lambda_P{i} = TS;
end
TS_vector_plot(TS_lambda_P);

% Covariance matrix    
profile on;
TS_lambda_P_cov = TS_vector_covariance_level(TS_lambda_P, 1, 5, 180);
profile viewer;
TS_plot(TS_lambda_P_cov{1,2});

% Extract matrix at single date
TS_matrix_sample1(TS_lambda_P_cov, datenum('12/05/2005'), CDX_NA_IG2.index_members(find(CDX_NA_IG2.dates{1}==datenum('12/05/2005')),:))
TS_matrix_sample1(TS_lambda_P_cov, datenum('12/05/2005'), [1:6 8:10]);

% Determine rank-one approximation
test = TS_matrix_sample1(TS_lambda_P_cov, datenum('12/05/2005'), [1:6 8:10]);
test(isnan(test))=0;
cov_lambda_P = (test + test' - diag(diag(test))) / 2;
[a_P,trash,c] = SVD_iterative(cov_lambda_P, 1);

% Compare a_P with a_Q
%a_Q = get_portfolio_parameters(cdx_mor, datenum('12/05/2005'), datenum('12/05/2005'));
a_Q = extract_cds_values(cdx_mor, 'ai', datenum('12/05/2005'));
plot(a_P, a_Q([1:6 8:13 15:20]));

% Time series of SVDs
TS_full_cov = TS_matrix_add_TS_matrix(TS_matrix_add_TS_matrix(TS_lambda_P_cov, TS_lambda_P_cov'), TS_matrix_mult_double(TS_matrix_diag(TS_lambda_P_cov), -1));
TS_matrix_sample1(TS_full_cov, datenum('12/05/2005'), [1:6 8:10])
% Quarterly frequency
[TS_vector_ev, TS_lambda] = TS_matrix_SVD(TS_full_cov, cdx_tv_quarterly.dates{1}, 1);
TS_plot(TS_lambda);
TS_vector_plot(TS_vector_ev, 0);
% Monthly frequency
[TS_vector_ev, TS_lambda] = TS_matrix_SVD(TS_full_cov, cdx_tv_monthly.dates{1}, 1);
TS_plot(TS_lambda);
TS_vector_plot(TS_vector_ev, 0);
% Weekly frequency
[TS_vector_ev, TS_lambda] = TS_matrix_SVD(TS_full_cov, cdx_tv_weekly.dates{1}, 1);
TS_plot(TS_lambda);
TS_vector_plot(TS_vector_ev, 0);
% Daily fequency
[TS_vector_ev, TS_lambda] = TS_matrix_SVD(TS_full_cov, CDX_NA_IG2.dates{1}, 1);
TS_plot(TS_lambda, 0);
TS_vector_plot(TS_vector_ev, 0);

% Separate Y_t and sigma_Y
TS_lambda = TS_sub_period(TS_lambda, datenum('09/21/2004'), datenum('01/01/2010'));
TS_plot(TS_volatility_level(TS_lambda, 1, 5, 40), 0);
[sigma_Y, TS_Y] = separate_Y_sigma_Y(TS_lambda);
TS_plot(TS_Y);

% Store fitted sigma_Y, Y_t, as well as factor loadings a_it^P in external file 
save('P_params daily.mat', 'TS_vector_ev', 'sigma_Y', 'TS_Y');

% Determine time series D_it = b_it * X_it and merge with CDX structure
CDX_NA_IG2 = CDX_merge_D_it(CDX_NA_IG2, TS_vector_ev, TS_Y);

% Analyze relationship between a_i^P, lambda_P, 5-yr CDS spread on '12/05/2005'
analyze_ai_P(CDX_NA_IG2, TS_vector_ev, datenum('12/05/2005'));

% Construct measure of CDS spread volatility (vs VIX in equity markets)
TS_vector_CDS = [];
for i=1:length(CDX_NA_IG2.portfolio)    
    cds = CDX_NA_IG2.portfolio(i);    
    TS = struct('values', cds.market_price{1}, 'dates', cds.dates{1});
    if isempty(TS.values)
        TS = [];
    end
    TS_vector_CDS{i} = TS;
end
TS_vector_plot(TS_vector_CDS);
TS_vector_CDS_vol = TS_vector_volatility_level(TS_vector_CDS, 3, 5, 40);
TS_vector_plot(TS_vector_CDS_vol);
% Vol based on average vol
TS_CDS_vol = TS_vector_average(TS_vector_CDS_vol);
TS_plot(TS_CDS_vol);
% Vol based on median vol
TS_CDS_vol2 = TS_vector_median(TS_vector_CDS_vol);
TS_plot(TS_CDS_vol2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Separation of Y_t, sigma_Y, and a_it^P/lambda^P %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Take sigma_Y as given from risk-neutral parameters
TS_sigma_Y = struct('dates', cdx_tv_weekly.dates{1}, 'values', cdx_tv_weekly.AJD_common_factor.sigma);
TS_plot(TS_sigma_Y);

% Construct time series of SUM of pairwise rolling covariancees (excluding diagonal elements)
TS_lambda_P = {};
for i=1:10 %length(CDX_NA_IG2.portfolio)    
    TS = struct('values', CDX_NA_IG2.portfolio(i).intensity_P, 'dates', CDX_NA_IG2.portfolio(i).dates{1});
    if isempty(TS.values)
        TS = [];
    end
    TS_lambda_P{i} = TS;
end
TS_lambda_P_cov = TS_vector_covariance_level(TS_lambda_P, 1, 5, 40);
TS_sum_cov_ij = TS_minus_TS(TS_matrix_sum(TS_lambda_P_cov), TS_matrix_sum(TS_matrix_diag(TS_lambda_P_cov)));
TS_sum_cov_ij = TS_sub_period(TS_sum_cov_ij, cdx_tv_monthly.dates{1}(1), cdx_tv_monthly.dates{1}(end));
TS_plot(TS_sum_cov_ij);

% Construct time series of MEDIAN of pairwise rolling covariancees
TS_lambda_P = {};
TS_index_members = {};
for i=1:length(CDX_NA_IG2.portfolio)    
    TS = struct('values', CDX_NA_IG2.portfolio(i).intensity_P, 'dates', CDX_NA_IG2.portfolio(i).dates{1});
    TS2 = struct('values', CDX_NA_IG2.index_members(:,i), 'dates', CDX_NA_IG2.dates{1});
    if isempty(TS.values)
        TS = [];
    end
    TS_lambda_P{i} = TS;
    TS_index_members{i} = TS2;
end
TS_lambda_P_cov = TS_vector_covariance_level(TS_lambda_P, 1, 5, 180);
TS_median_cov_ij = TS_matrix_function(TS_lambda_P_cov, @median, TS_index_members, TS_index_members);
TS_median_cov_ij = TS_sub_period(TS_median_cov_ij, cdx_tv_monthly.dates{1}(1), cdx_tv_monthly.dates{1}(end));
TS_plot(TS_median_cov_ij)

% % Construct time series of SUM of pairwise products of default intensities
% TS_lambda_ij = TS_vector_outer_product(TS_lambda_P, TS_lambda_P);
% TS_sum_lambda_ij = TS_mult_double(TS_minus_TS(TS_matrix_sum(TS_lambda_ij), TS_matrix_sum(TS_matrix_diag(TS_lambda_ij))), 0.5);
% TS_plot(TS_sum_lambda_ij)

% Construct time series of MEDIAN of pairwise products of default intensities
TS_lambda_ij = TS_vector_outer_product(TS_lambda_P, TS_lambda_P);
TS_median_lambda_ij = TS_matrix_function(TS_lambda_ij, @median, TS_index_members, TS_index_members);
TS_plot(TS_median_lambda_ij)

% Separate Y_t and a_it^P/lambda^P
TS_Dt = TS_divide_TS(TS_divide_TS(TS_median_cov_ij, TS_median_lambda_ij), TS_mult_TS(TS_sigma_Y, TS_sigma_Y));
TS_Dt = TS_remove_NaN(TS_Dt);
TS_Dt = TS_sub_period(TS_Dt, cdx_tv_monthly.dates{1}(1), cdx_tv_monthly.dates{1}(end));
TS_plot(TS_Dt)
% TS_plot(TS_mult_double(TS_volatility_level(TS_Dt, 1, 5, 40), 1/22^2))
% TS_Y = TS_mult_double(TS_Dt, 1/22^2);
% TS_plot(TS_Y);
[TS_omega4, TS_Y] = separate_TS_Dt(TS_Dt, TS_sigma_Y);
TS_plot(TS_Y)

% Separate Y_t and a_it^P/lambda^P - use use sigma_Y from cdx_tv_monthly10
TS_sigma_Y10 = struct('dates', cdx_tv_monthly10.dates{1}, 'values', cdx_tv_monthly10.AJD_common_factor.sigma);
TS_Dt = TS_divide_TS(TS_divide_TS(TS_median_cov_ij, TS_median_lambda_ij), TS_mult_TS(TS_sigma_Y10, TS_sigma_Y10));
TS_Dt = TS_remove_NaN(TS_Dt);
TS_Dt = TS_sub_period(TS_Dt, cdx_tv_monthly.dates{1}(1), cdx_tv_monthly.dates{1}(end));
TS_plot(TS_Dt)
[TS_omega4, TS_Y] = separate_TS_Dt(TS_Dt, TS_sigma_Y10);
TS_plot(TS_Y)

% Check if b_it * X_it obtained in this way are positive
TS_plot(TS_mult_TS(TS_Y, TS_omega4))    % ... needs to be in [0,1]

% Does DTD have weekly fluctuations?
hist(weekday(CDX_NA_IG2.portfolio(1).dates{1}([1; 1+find(diff(CDX_NA_IG2.portfolio(1).DTD)>0)])))
hist(weekday(CDX_NA_IG2.portfolio(1).dates{1}([1; 1+find(diff(CDX_NA_IG2.portfolio(1).intensity_P)>0)])))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Examine whether Y_t at sigma_Y_t (from fitting tranche prices alone) are consistent (Algorithm 4 - Step 1) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Calculate standardized innovations - cdx_tv_monthly10
TS_Y10 = struct('dates', cdx_tv_monthly10.dates{1}, 'values', cdx_tv_monthly10.y0);
TS_sigma_Y10 = struct('dates', cdx_tv_monthly10.dates{1}, 'values', cdx_tv_monthly10.AJD_common_factor.sigma);
TS_plot(TS_Y10)
TS_plot(TS_sigma_Y10)
% Calculate standardized innovations
TS_eps = TS_divide_TS(TS_return(TS_Y10, 1), TS_mult_TS(TS_power(TS_mult_TS(TS_mult_double(TS_delta_t(TS_Y10), 1/365), TS_Y10), 0.5), TS_sigma_Y10));
TS_eps = TS_remove_NaN(TS_eps);
TS_plot(TS_eps)
mean(TS_eps.values)
median(TS_eps.values)
std(TS_eps.values)
median(abs(TS_eps.values)) / norminv(0.75)
% Same, but exclude May 2005
TS_eps2 = struct('dates', [TS_eps.dates(1:7); TS_eps.dates(9:end)], 'values', [TS_eps.values(1:7); TS_eps.values(9:end)]);
TS_plot(TS_eps2)
mean(TS_eps2.values)
median(TS_eps2.values)
std(TS_eps2.values)
median(abs(TS_eps2.values)) / norminv(0.75)

% Calculate standardized innovations - cdx_tv_weekly
TS_Y10 = struct('dates', cdx_tv_weekly.dates{1}, 'values', cdx_tv_weekly.y0);
TS_sigma_Y10 = struct('dates', cdx_tv_monthly10.dates{1}, 'values', cdx_tv_monthly10.AJD_common_factor.sigma);
TS_eps = TS_divide_TS(TS_return(TS_Y10, 1), TS_mult_TS(TS_power(TS_mult_TS(TS_mult_double(TS_delta_t(TS_Y10), 1/365), TS_Y10), 0.5), TS_sigma_Y10));
TS_eps = TS_remove_NaN(TS_eps);
TS_plot(TS_eps)
hist(TS_eps.values)
mean(TS_eps.values)
std(TS_eps.values)

%%%%%%%%%%%%%%%%%%%%%%%%
% Algorithm 4 - Step 2 %
%%%%%%%%%%%%%%%%%%%%%%%%

% Calculate omega_4
TS_Y10 = struct('dates', cdx_tv_monthly10.dates{1}, 'values', cdx_tv_monthly10.y0);
TS_sigma_Y10 = struct('dates', cdx_tv_monthly10.dates{1}, 'values', cdx_tv_monthly10.AJD_common_factor.sigma);
TS_omega4 = TS_power(TS_divide_TS(TS_median_cov_ij, TS_mult_TS(TS_sigma_Y10, TS_sigma_Y10, TS_Y10, TS_median_lambda_ij)), 0.5);
TS_plot(TS_omega4)

% Check if b_it * X_it obtained in this way are positive
TS_plot(TS_mult_TS(TS_Y10, TS_omega4))    % ... needs to be in [0,1]

% Calculate time series of a_it^P and b_it^P and merge with CDX structure
cdx_tv_monthly10 = CDX_insert_a_b_P(cdx_tv_monthly10, TS_Y10, TS_omega4);

% Analyze stability of physical factor loadings a_it_P and b_it_P over time: median, mean, ratio, ...
TS_vector_ai_P = extract_cds_field_TS(cdx_tv_monthly10, 'ai_P');
TS_vector_bi_P = extract_cds_field_TS(cdx_tv_monthly10, 'bi_P');
TS_vector_ai = extract_cds_field_TS(cdx_tv_monthly10, 'ai');
TS_vector_bi = extract_cds_field_TS(cdx_tv_monthly10, 'bi');
TS_index_members = {};
for i=1:length(cdx_tv_monthly10.portfolio)
    TS3 = struct('values', cdx_tv_monthly10.index_members(:,i), 'dates', cdx_tv_monthly10.dates{1});
    TS_index_members{i,1} = TS3;
end
% Summary plots for a_it
TS_plot(TS_matrix_function(TS_vector_ai_P, @median, TS_index_members))
TS_plot(TS_matrix_function(TS_vector_ai_P, @mean, TS_index_members))
TS_plot(TS_matrix_function(TS_matrix_divide_TS_matrix(TS_vector_ai_P, TS_vector_ai), @median, TS_index_members))
ylabel('ai')
TS_plot(TS_matrix_function(TS_matrix_divide_TS_matrix(TS_vector_ai_P, TS_vector_ai), @mean, TS_index_members))
% Summary plots for b_it
TS_plot(TS_matrix_function(TS_vector_bi_P, @median, TS_index_members))
TS_plot(TS_matrix_function(TS_vector_bi_P, @mean, TS_index_members))
TS_plot(TS_matrix_function(TS_matrix_divide_TS_matrix(TS_vector_bi_P, TS_vector_bi), @median, TS_index_members))
ylabel('bi')
TS_plot(TS_matrix_function(TS_matrix_divide_TS_matrix(TS_vector_bi_P, TS_vector_bi), @mean, TS_index_members))
% Plot together
TS1 = TS_matrix_function(TS_matrix_divide_TS_matrix(TS_vector_ai_P, TS_vector_ai), @median, TS_index_members);
TS2 = TS_matrix_function(TS_matrix_divide_TS_matrix(TS_vector_bi_P, TS_vector_bi), @median, TS_index_members);
TS_vector_plot({TS1; TS2})
ylabel('ratio')

% Plot Y_t / median(lambda_t^Q) and Y_t / mean(lambda_t^Q) over time
plot_syst_risk_fraction(cdx_tv_monthly10)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Likelihood inference of time series %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

TS_X1 = struct('values', cdx_tv_monthly10.portfolio(1).x0, 'dates', cdx_tv_monthly10.portfolio(1).dates{1});
TS_plot(TS_X1)
TS_plot(TS_X2)
TS_params = cdx_tv_monthly10.portfolio(1).AJD;
TS_likelihood(TS_X1, 1, TS_params);
TS_likelihood_fixed_params([0.2; 1e-3; 0.1; 0.1; 0.01], TS_X1, 1)

% Optimize LH of AJD parameters - one time series
TS_X1 = struct('values', cdx_tv_monthly10.portfolio(1).x0, 'dates', cdx_tv_monthly10.portfolio(1).dates{1});
TS_X2 = struct('values', cdx_tv_monthly10.portfolio(2).x0, 'dates', cdx_tv_monthly10.portfolio(2).dates{1});
TS_likelihood_fixed_params([0.2; 1e-3; 0.1; 0.1; 0.01], TS_X1, 1)
TS_likelihood_fixed_params([0.2; 1e-2; 0.1; 0.1; 0.01], TS_X2, 1)
x0_new = optimize_LH_AJD([4.2443  0.00011241     0.03089      3.8795  0.00045162]', TS_X1, 0, 1);
x0_new2 = optimize_LH_AJD([2.3062   0.0015076    0.073569      3.2301   0.0065128]', TS_X2, 0, 0);
% Feller(x0_new);

% Optimize LH of AJD parameters - multiple time series with parameter constraints across individual
% time series
TS_vector = {TS_X1; TS_X2};
TS_params = struct('k', 0.05, 'theta', 100, 'sigma', 2, 'L', 5, 'mu', 10, 'dates', datenum('01/01/2000'));
TS_params2 = struct('k', 0.2, 'theta', 200, 'sigma', 5, 'L', 5, 'mu', 50, 'dates', datenum('01/01/2000'));
TS_vector_params_Q = {TS_params; TS_params2};
TS_vector_likelihood_fixed_params([1.5849; 7.4548; 0.6326; 3.2656], TS_vector, TS_vector_params_Q, 0);
x0_new = optimize_LH_AJD_vector([0.4; 3; 1; 2],  TS_vector, TS_vector_params_Q, 0);

%%%
%%% Algorithm I: (k,L,mu) are the parameters %%%
%%%
% Use time-fixed parameters for k,L,mu, but time-varing (k*theta), sigma (given externsally)
TS_likelihood_fixed_params_partial([0.2; 1e-3; 0.1;], cdx_tv_monthly10.portfolio(1).AJD, TS_X1, 1, 1)
TS_likelihood_fixed_params_partial([0.2; 1e-3; 0.1;], cdx_tv_monthly10.portfolio(2).AJD, TS_X2, 1, 1)
likelihood_fixed_params_partial_CDX([3.7301; 1.8634; 0.00110691;], cdx_tv_monthly10);

% Optimize LH of parameters k_P, l_P, mu_P
A = [-eye(3); eye(3)];
b = [-0.01;  -0.01; -1e-4; ...
         5;      5;   0.1;];
options = optimset('MaxFunEvals',200,'MaxIter', 50,'DiffMaxChange',1,'TypicalX',1e-2,'TolX',1e-4,'TolFun',1e-4); %,'DiffMinChange',1e-3);
theta_P = fmincon(@likelihood_fixed_params_partial_CDX, [1; 0.175; 0.01;], A, b, [], [], [], [], [], options, cdx_tv_monthly10);

%%%
%%% Algorithm II: (k,L,omega4) are the parameters, where mu_i^P = omega4 * X_it %%%
%%%
TS_likelihood_fixed_params_partial2([0.2; 1e-3; 0.1;], cdx_tv_monthly10.portfolio(1).AJD, TS_X1, 1, 1)
likelihood_fixed_params_partial2_CDX([3.4041; 1.2368; 3.1498;], cdx_tv_monthly10);
A = [-eye(3); eye(3)];
b = [-0.01;  -0.01; -1e-2; ...
         5;      5;   10;];
options = optimset('MaxFunEvals',200,'MaxIter', 50,'DiffMaxChange',1,'TypicalX',1e-2,'TolX',1e-4,'TolFun',1e-4); %,'DiffMinChange',1e-3);
theta_P2 = fmincon(@likelihood_fixed_params_partial2_CDX, [3.15; 0.7; 0.1;], A, b, [], [], [], [], [], options, cdx_tv_monthly10);

%%%
%%% Algorithm III: (k,omega5,omega4) are the parameters, where mu_i^P = omega4 * X_it and l_i^P = omega5 * X_it %%%
%%%
TS_likelihood_fixed_params_partial3([0.2; 0.1; 0.1;], cdx_tv_monthly10.portfolio(1).AJD, TS_X1, 1, 1)
likelihood_fixed_params_partial3_CDX([3.1808; 403.4989; 3.3904;], cdx_tv_monthly10);
A = [-eye(3); eye(3)];
b = [-0.01;    -1; -0.01; ...
         5;  1000;   10;];
options = optimset('MaxFunEvals',500,'MaxIter', 100,'DiffMaxChange',1,'TypicalX',1e-2,'TolX',1e-4,'TolFun',1e-4); %,'DiffMinChange',1e-3);
theta_P3 = fmincon(@likelihood_fixed_params_partial3_CDX, [3.15; 5; 8;], A, b, [], [], [], [], [], options, cdx_tv_monthly10);

%%%
%%% Algorithm IV: (k_i,l_P,mu_P) are the parameters
%%%
m = length(cdx_tv_monthly10.portfolio);
TS_likelihood_fixed_params_partial([6.0229; 2.9353; 0.00059614], cdx_tv_monthly10.portfolio(1).AJD, TS_X1, 1, 1);
likelihood_fixed_params_partial4_CDX([3; 0.0006; ones(m, 1);], cdx_tv_monthly10);
likelihood_fixed_params_partial4_CDX(theta_P4, cdx_tv_monthly10);
A = [-eye(m+2); eye(m+2)];
b = [ -0.005;  -0.0005;    repmat(-0.01, m, 1);  ...
          10;      10;    repmat(5, m, 1);     ];
options = optimset('MaxFunEvals', 20000,'MaxIter', 2000,'DiffMaxChange',1,'TypicalX',1e-2,'TolX',1e-4,'TolFun',1e-4); %,'DiffMinChange',1e-3);
theta_P4 = fmincon(@likelihood_fixed_params_partial4_CDX, theta_P4, A, b, [], [], [], [], [], options, cdx_tv_monthly10);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Determine decomposition of tranche spreads %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 5-year index and tranche spreads
tranche_spread_decomposition(cdx_tv_monthly10, discounts_IMM, datenum('12/01/2005'), 2^18, [1 1 1 0], [1 1 1], 0, theta_P, 1)
tranche_spread_decomposition(cdx_tv_monthly10, discounts_IMM, datenum('12/01/2005'), 2^18, [1 1 1 0], [1 1 1], 0, [1.34; theta_P(2:3)], 1)

tranche_spread_decomposition(cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), 2^18, [1 1 1 0], [1 1 1], 0, theta_P, 1)
tranche_spread_decomposition(cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), 2^18, [1 1 1 0], [1 1 1], 0, theta_P2, 2)
tranche_spread_decomposition(cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), 2^18, [1 1 1 0], [1 1 1], 0, theta_P3, 3)
%tranche_spread_decomposition(cdx_tv_monthly10, discounts_IMM, datenum('11/02/2004'), 2^18, [1 1 1 0], [1 1 1], 0, theta_P, 1)

tranche_spread_decomposition(cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), 2^18, [1 1 1 0], [1 1 1], 0, [1.34; theta_P(2:3)], 1)
tranche_spread_decomposition(cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), 2^18, [1 1 1 0], [1 1 1], 0, [1.34; theta_P2(2:3)], 2)
tranche_spread_decomposition(cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), 2^18, [1 1 1 0], [1 1 1], 0, [1.34; theta_P3(2:3)], 3)

% 1,2,3,4,5 year index spreads
test = cdx_tv_monthly10;
index_decomp = [];
while (min(test.T{1}) > 0)
    [tmp] = tranche_spread_decomposition(test, discounts_IMM, datenum('12/01/2005'), 2^18, [1 1 1 0], [1 1 1], 0);
    index_decomp = [index_decomp; tmp'];
    test.T{1} = test.T{1} - 1;
end
bar1 = bar(index_decomp, 'stack', 'BarWidth',0.6);
set(gca,['x','ticklabel'], {'1yr' '2yr' '3yr' '4yr' '5yr'});
h = findobj(gca,'Type','patch');
ylabel('fraction');
%colormap gray
colormap pink;
set(bar1(1), 'FaceColor', [0.502 0.502 0.502]);
legend({'Expected Loss' 'MTM Sytematic' 'MTM Idiosyncratic' 'JTD RP' 'Correlation RP'}, 'Location', 'NorthEast');
axis([0.5 5.5 0 1.00000001])

for i=1:length(cdx_tv_monthly10.portfolio)
    cds = cdx_tv_monthly10.portfolio(i);
    if (max(cds.ai_P) > 10)
        disp(i);
    end
end

% Determine fraction of spread that due to expected lossed bases on ratings of firms in portfolio
spread_fraction_losses_rating(cdx_tv_monthly10, datenum('12/01/2005'))
spread_fraction_losses_rating(cdx_tv_monthly10, datenum('11/01/2006'))
fractions = [];
for i=1:length(cdx_tv_monthly.dates{1})
   fractions(i) = spread_fraction_losses_rating(cdx_tv_monthly10, cdx_tv_monthly10.dates{1}(i));
end
TS_fraction = struct('dates', cdx_tv_monthly10.dates{1}, 'values', fractions);
TS_plot(TS_fraction);

% Determine time series of tranche spread decompositions
[tranche_fractions, index_fractions, frac_average, frac_min, frac_max, frac_std, idx_frac_average, idx_frac_std] = ...
        table_tranche_spread_decomp(cdx_tv_monthly10, discounts_IMM, 2^18, [1 1 1 0], [1 1 1], 0, [1.34; theta_P(2:3)], 1, 1);
plot(index_fractions); legend({'Expected Loss' 'MPR Sytematic' 'MPR Idiosyncratic' 'Pure JTD RP' 'Correlation RP'}, 'Location', 'NorthEast');
plot(squeeze(tranche_fractions(:,:,1))); legend({'Expected Loss' 'MPR Sytematic' 'MPR Idiosyncratic' 'Pure JTD RP' 'Correlation RP'}, 'Location', 'NorthEast');
plot(squeeze(tranche_fractions(:,:,2))); legend({'Expected Loss' 'MPR Sytematic' 'MPR Idiosyncratic' 'Pure JTD RP' 'Correlation RP'}, 'Location', 'NorthEast');
plot(squeeze(tranche_fractions(:,:,3))); legend({'Expected Loss' 'MPR Sytematic' 'MPR Idiosyncratic' 'Pure JTD RP' 'Correlation RP'}, 'Location', 'NorthEast');
plot(squeeze(tranche_fractions(:,:,4))); legend({'Expected Loss' 'MPR Sytematic' 'MPR Idiosyncratic' 'Pure JTD RP' 'Correlation RP'}, 'Location', 'NorthEast');
plot(squeeze(tranche_fractions(:,:,5))); legend({'Expected Loss' 'MPR Sytematic' 'MPR Idiosyncratic' 'Pure JTD RP' 'Correlation RP'}, 'Location', 'NorthEast');

% Determine time series of expected loss decompositions
[tranche_fractions, index_fractions, frac_average, frac_min, frac_max, frac_std, idx_frac_average, idx_frac_std] = ...
        table_tranche_spread_decomp(cdx_tv_monthly10, discounts_IMM, 2^18, [1 1 1 0], [1 1 1], 0, [1.34; theta_P(2:3)], 1, 2);
plot(index_fractions); legend({'Expected Loss' 'MPR Sytematic' 'MPR Idiosyncratic' 'Pure JTD RP' 'Correlation RP'}, 'Location', 'NorthEast');
plot(squeeze(tranche_fractions(:,:,1))); legend({'Expected Loss' 'MPR Sytematic' 'MPR Idiosyncratic' 'Pure JTD RP' 'Correlation RP'}, 'Location', 'NorthEast');
plot(squeeze(tranche_fractions(:,:,2))); legend({'Expected Loss' 'MPR Sytematic' 'MPR Idiosyncratic' 'Pure JTD RP' 'Correlation RP'}, 'Location', 'NorthEast');
plot(squeeze(tranche_fractions(:,:,3))); legend({'Expected Loss' 'MPR Sytematic' 'MPR Idiosyncratic' 'Pure JTD RP' 'Correlation RP'}, 'Location', 'NorthEast');
plot(squeeze(tranche_fractions(:,:,4))); legend({'Expected Loss' 'MPR Sytematic' 'MPR Idiosyncratic' 'Pure JTD RP' 'Correlation RP'}, 'Location', 'NorthEast');
plot(squeeze(tranche_fractions(:,:,5))); legend({'Expected Loss' 'MPR Sytematic' 'MPR Idiosyncratic' 'Pure JTD RP' 'Correlation RP'}, 'Location', 'NorthEast');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Determine decomposition of CDS spread %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Fit dynamics of single CDS
TS_X1 = struct('values', cdx_tv_monthly10.portfolio(1).x0, 'dates', cdx_tv_monthly10.portfolio(1).dates{1});
TS_likelihood_fixed_params_partial([6.0229; 2.9353; 0.00059614], cdx_tv_monthly10.portfolio(1).AJD, TS_X1, 1, 1);
A = [-eye(3); eye(3)];
b = [-0.01;    -0.001; -0.0005; ...
         20;  10;  0.1;];
options = optimset('MaxFunEvals',200,'MaxIter', 50,'DiffMaxChange',1,'TypicalX',1e-2,'TolX',1e-4,'TolFun',1e-4);
theta_P_X1 = fmincon(@TS_likelihood_fixed_params_partial, [1; 0.175; 0.01;], A, b, [], [], [], [], [], options, cdx_tv_monthly10.portfolio(1).AJD, TS_X1, 1, 1);

% Alcoa
cds_spread_decomposition(1, cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), [1 1 1 1], 0, theta_P, 1)
cds_spread_decomposition(1, cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), [1 1 1 1], 0, theta_P2, 2)
cds_spread_decomposition(1, cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), [1 1 1 1], 0, theta_P3, 3)

cds_spread_decomposition(1, cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), [1 1 1 1], 0, [1.34; theta_P(2:3)], 1)
cds_spread_decomposition(1, cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), [1 1 1 1], 0, [1.34; theta_P2(2:3)], 2)
cds_spread_decomposition(1, cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), [1 1 1 1], 0, [1.34; theta_P3(2:3)], 3)

cds_spread_decomposition(1, cdx_tv_monthly10, discounts_IMM, datenum('12/01/2005'), [1 1 1 1], 0, theta_P, 1)
cds_spread_decomposition(1, cdx_tv_monthly10, discounts_IMM, datenum('12/01/2005'), [1 1 1 1], 0, [0.46; theta_P(2:3)], 1)
cds_spread_decomposition(1, cdx_tv_monthly10, discounts_IMM, datenum('12/01/2005'), [1 1 1 1], 0, [1.34; theta_P(2:3)], 1)

% WMT
cds_spread_decomposition(138, cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), [1 1 1 1], 0, theta_P, 1)
cds_spread_decomposition(138, cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), [1 1 1 1], 0, theta_P2, 2)
cds_spread_decomposition(138, cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), [1 1 1 1], 0, theta_P3, 3)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compare senior tranche and CDS risk characteristics %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[trash, tranche_fractions] = tranche_spread_decomposition(cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), 2^18, [1 1 1 0], [1 1 1], 0, [1.34; theta_P(2:3)], 1);
WMT_fractions = cds_spread_decomposition(138, cdx_tv_monthly10, discounts_IMM, datenum('11/01/2006'), [1 1 1 1], 0, theta_P, 1);


