function log_LH = likelihood_fixed_params_partial_CDX(x0, CDX)
% --------------------------------------------------------------------------------------------------
% Calculate likelihood of all idiosyncratic default intensity time series for all index members in a
% CDX structure. The free parameters are (k,L,mu), which are constant over time, while (k*theta)_t,
% sigma_t are externally given and time varying.
% --------------------------------------------------------------------------------------------------
% x0            ... [k,L,mu]
% CDX           ... credit index structure
% --------------------------------------------------------------------------------------------------
% sample call: likelihood_fixed_params_partial_CDX([0.2; 1e-3; 0.1;], cdx_tv_monthly10);
% --------------------------------------------------------------------------------------------------

% Calculate likelihood of cds.x0 for each company at dates where it is a member of the index
log_LH = 0;
for i=1:length(CDX.portfolio)
    % Determine dates at which firm is member of CDX index
    cds = CDX.portfolio(i);
    member_dates = CDX.dates{1}(logical(CDX.index_members(:,i)));
    used_pos_cds = logical(is_member_sorted_c(cds.dates{1}, member_dates));
    used_dates = cds.dates{1}(used_pos_cds);
    
    % Extract time series of X_it (only use if at least two dates available)
    if (sum(used_pos_cds) < 2)
        continue;
    end
    TS_X_it = struct('dates', used_dates, 'values', cds.x0(used_pos_cds));
    
    % Calculate LH of X_it
    log_LH = log_LH + TS_likelihood_fixed_params_partial(x0, CDX.portfolio(i).AJD, TS_X_it, 1, 0);
end
disp(['Total portfolio negative log-LH: ' num2str(log_LH)]);