function x0_new = optimize_LH_AJD(x0, TS, ind_Feller, display)
% --------------------------------------------------------------------------------------------------
% Optimize the LH-function of time-fixed AJD parameters for a certain time series.
% --------------------------------------------------------------------------------------------------
% x0            ... starting value for [k,theta,sigma,L,mu]
% TS            ... structure with values and dates
% ind_Feller    ... indicator whether to impose Feller condition k*theta >= sigma^2/2
% display       ... whether to display likelihood, default: yes
% --------------------------------------------------------------------------------------------------
% sample call: optimize_LH_AJD([0.2; 50; 0.5; 0.5; 5], TS)
% --------------------------------------------------------------------------------------------------

% Define search interval
A = [-eye(5); eye(5)];
b = [-0.01;  -1e-4; -1e-4; -0.01; -1e-4; ...
         5;      1;    10;    10;  0.5;];

% Use Newton-Raphson to minimize negative log-LG RMSE pricing error for CDX
options = optimset('MaxFunEvals',1000,'MaxIter', 50,'DiffMaxChange',1,'TypicalX',1e-2,'TolX',1e-4,'TolFun',1e-4); %,'DiffMinChange',1e-3);
if (ind_Feller == 1)
    x0_new = fmincon(@TS_likelihood_fixed_params, x0, A, b, [], [], [], [], @Feller, options, TS, 1, display);
else
    x0_new = fmincon(@TS_likelihood_fixed_params, x0, A, b, [], [], [], [], [], options, TS, 1, display);
end

% Display results at very end
TS_likelihood_fixed_params(x0, TS, 1);