function x0_new = optimize_LH_AJD_vector(x0, TS_vector, TS_vector_params_Q, ind_Feller)
% --------------------------------------------------------------------------------------------------
% Optimize the LH-function of time-fixed AJD parameters for a multi-dimensional time series.
% --------------------------------------------------------------------------------------------------
% x0                    ... starting value for [k^P, Avg_t(theta_it^Q)/theta_i^P, Avg_t(L_i^Q)/L_i^P, Avg_t(mu_i^Q)/mu_i^P]
% TS_vector             ... vector of time series
% TS_vector_params_Q    ... vector of parameter time series
% ind_Feller            ... indicator whether to impose Feller condition k*theta >= sigma^2/2
% --------------------------------------------------------------------------------------------------
% sample call: x0_new = optimize_LH_AJD_vector([0.05; 2; 2; 5],  TS_vector, TS_vector_params_Q, 1);
% --------------------------------------------------------------------------------------------------

% Define search interval
A = [-eye(4); eye(4)];
b = [-0.01;   -0.1;  -1e-2;  -0.01;  ...
         5;     10;    100;    100;];

% Use Newton-Raphson to minimize negative log-LG RMSE pricing error for CDX
options = optimset('MaxFunEvals',1000,'MaxIter', 50,'DiffMaxChange',1,'TypicalX',1e-2,'TolX',1e-4,'TolFun',1e-4); %,'DiffMinChange',1e-3);
if (ind_Feller == 1)
    x0_new = fmincon(@TS_vector_likelihood_fixed_params, x0, A, b, [], [], [], [], @Feller, options, TS_vector, TS_vector_params_Q, 0);
else
    x0_new = fmincon(@TS_vector_likelihood_fixed_params, x0, A, b, [], [], [], [], [], options, TS_vector, TS_vector_params_Q, 0);
end