function plot_empirical_vol_vs_spread(CDX, tickers, date, maturity, transform)
% --------------------------------------------------------------------------------------------------
% Plot empirical 5-yr CDS spread volatility vs. X-yr CDS spread
% --------------------------------------------------------------------------------------------------
% CDX           ... credit index structure
% tickers       ... list of companies for which to return volatility
% date          ... date for which to return volatility
% maturity      ... which maturity of spreads to use
% transform     ... function to be applied to spreads
% --------------------------------------------------------------------------------------------------
% sample call: plot_empirical_vol_vs_spread(CDX_NA_IG2, tickers, '12/05/2005', 1, @sqrt)
% --------------------------------------------------------------------------------------------------

% Extract volatilities
date = datenum(date);
vols = CDX_get_vols(CDX, tickers, '12/05/2005');

% Extract CDS spreads
all_tickers = {CDX.portfolio.ticker}';
spreads = zeros(length(tickers), 1);
for i=1:length(tickers)
    match = find(strcmp(all_tickers, tickers(i)));
    if (~isempty(match))
        % Determine position of matching (or last available) date
        cds = CDX.portfolio(match);
        date_pos = find(cds.dates{1} <= date, 1, 'last');
        if (isempty(date_pos))
            spreads(i) = -1;
            continue;
        end
        spreads(i) = cds.market_price{maturity}(date_pos);
    else
        spreads(i) = -1;
    end
end

% Apply transform to spreads
if (nargin > 3)
    spreads = transform(spreads);
end

% Make plot
used = (vols > 0);
scatter(vols(used), spreads(used));
xlabel('vol');
ylabel('spread');