function [TS_omega4, TS_Y] = separate_TS_Dt(TS, TS_sigma_Y)
% --------------------------------------------------------------------------------------------------
% Separate TS_dt into omega_4 and TS_y
% --------------------------------------------------------------------------------------------------
% TS            ... time series of Dt values
% TS_sigma_Y    ... time seires of volatility of common factor
% --------------------------------------------------------------------------------------------------
% sample call: separate_TS_Dt(TS_Dt)
% --------------------------------------------------------------------------------------------------

% Define search interval for sigma_Y
lower = 1e-6;
upper = 0.1;
eps = 1e-4;
TS_dt = TS_delta_t(TS);
dt = TS_dt.values / 365;

% Solve for omega_4 and TS_y
qvar_DT = mean(diff(TS.values).^2 ./ dt);
TS_Y = TS_mult_double(TS_power(TS_mult_TS(TS_sigma_Y, TS), 2), 1/qvar_DT);
TS_omega4 = TS_power(TS_divide_TS(TS, TS_Y), 0.5);

% % Interval search for omega_4
% while (upper-lower > eps)
%     % Calculate implied vol in middle of search interval
%     middle = (lower + upper)/2;
%     qvar_DT = sqrt(mean((diff(TS.values / middle^2)).^2 ./ dt));
%     TS_Y = TS_mult_double(TS_divide_TS(qvar_DT, TS_power(TS_sigma_Y, 2)), 1/middle^2);
%     vol_Y = 
%     
%     % Narrow down search interval
%     if (vol_middle > middle)
%         lower = middle;
%     else
%         upper = middle;
%     end
% end
% 
% % Calculate Y_t time series
% omega_4 = (lower + upper)/2;
% TS_Y = TS_mult_double(TS, 1/sigma_Y^2);