function [sigma_Y, TS_Y] = separate_Y_sigma_Y(TS)
% --------------------------------------------------------------------------------------------------
% Separate the lambdas (C_t) of the rank-one approximation of the covariance matrix into Y_t and
% sigma_Y, such that Var(Y_t) = sigma_Y^2.
% --------------------------------------------------------------------------------------------------
% TS            ... time series of C_t values
% --------------------------------------------------------------------------------------------------
% sample call: separate_Y_sigma_Y(TS_lambda);
% --------------------------------------------------------------------------------------------------

% Define search interval for sigma_Y
lower = 1e-6;
upper = 0.1;
eps = 1e-4;
TS_dt = TS_delta_t(TS);
dt = TS_dt.values / 365;

% Interval search for sigma_Y
%vol_lower = mean(diff((TS.values / lower^2)).^2 .* dt);
%vol_upper = mean(diff((TS.values / upper^2)).^2 .* dt);
while (upper-lower > eps)
    % Calculate implied vol in middle of search interval
    middle = (lower + upper)/2;
    vol_middle = sqrt(mean((diff(TS.values / middle^2)).^2 ./ dt));
    
    % Narrow down search interval
    if (vol_middle > middle)
        lower = middle;
    else
        upper = middle;
    end
end

% Calculate Y_t time series
sigma_Y = (lower + upper)/2;
TS_Y = TS_mult_double(TS, 1/sigma_Y^2);