function spread_frac = spread_fraction_losses_rating(CDX, date)
% --------------------------------------------------------------------------------------------------
% Determine fraction of spread that due to expected losses based on ratings of firms in portfolio
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% date      ...
% --------------------------------------------------------------------------------------------------
% sample call: spread_fraction_losses_rating(cdx_tv_monthly10, datenum('12/01/2005'))
% --------------------------------------------------------------------------------------------------

% Determine date_pos
date = datenum(date);
date_pos = find(CDX.dates{1} == date);

% Determine expected losses based on historial ratings
ratings = extract_cds_values(CDX, 'rating', date);
ratings = ratings(logical(CDX.index_members(date_pos, :)));
ratings = ratings(~isnan(ratings));
ratings = ratings(ratings > 0);
rating_def_probs = [0.20; 0.97; 1.37; 3.51; 10.04; 20.89;] / 100;

% Calculate fraction of losses due to expected losses
spread_frac = mean( -log(1-rating_def_probs(ratings))/ 5) * 0.6 / CDX.index_market_price{1}(date_pos) * 1e4;
