function liq_error = wrapper_liq_tranche_mispricing(liq_prem_tranches, CDX, discounts_IMM, start_date_num, end_date_num, N, maturities_cds, ...
                                                    maturities_tranches, RMSE_method, LGD_method, method5, method2, CDX2)
% --------------------------------------------------------------------------------------------------
% Wrapper function that calculates the pricing error of credit index vs. cds. The error is a sum of
% the errors for different maturities.
% --------------------------------------------------------------------------------------------------
% liq_prem_tranches             ... liquidity premium of tranches vs. index
% CDX                           ... credit index structure (see 'all_steps_in_a_row.m')
% discounts_IMM                 ... structure with discount curves matching IMM dates
% start_date_num                ... datenum of start date
% end_date_num                  ... datenum of end date
% N                             ... number of points for numerical integration of Fourier transform
% maturities_cds                ... which maturities to fit for CDS prices, default: all
% maturities_tranches           ... which maturities to take into account for calculating liq_error
% RMSE_method                   ... which definition of pricing error to use
% LGD_method                    ... method for (joint) distribution of LGDs
% method5                       ... which definition to use for the 5th parameters
%                                   'mu' = expected jump size \mu (default)
%                                   'mu*L' = jump intensity x jump size
% method2                       ... which definition to use for the 2nd parameter
%                               ... 'thet' = theta_total
%                               ... 'thet*k' = theta_total * k
% CDX2                          ... second CDX structure for robust RMSE calculation (optional)
% --------------------------------------------------------------------------------------------------
% sample call: wrapper_liq_tranche_mispricing(cdx_mor, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 10000, [1 0 0 1], [1 0 0], 1, 0, ...)
% --------------------------------------------------------------------------------------------------

% Determine relevant date range
start_pos = find(CDX.dates{1} >= start_date_num, 1, 'first');
end_pos = find(CDX.dates{1} <= end_date_num, 1, 'last');
used_range = start_pos:end_pos;
used_dates = CDX.dates{1}(used_range);

% Determine which dates are available
%available_5yr = (CDX.index_market_price{1}(used_range) > 0);
start_pos = find(CDX.dates{2} >= start_date_num, 1, 'first');
end_pos = find(CDX.dates{2} <= end_date_num, 1, 'last');
used_range2 = start_pos:end_pos;
%available_7yr = (CDX.index_market_price{2}(used_range2) > 0);
start_pos = find(CDX.dates{3} >= start_date_num, 1, 'first');
end_pos = find(CDX.dates{3} <= end_date_num, 1, 'last');
used_range3 = start_pos:end_pos;
%available_10yr = (CDX.index_market_price{3}(used_range3) > 0);

% Calculate index and tranche prices
CDX.liq_prem_tranches(used_range, :) = liq_prem_tranches;
CDX = update_model_price_index(CDX, discounts_IMM, [1 1 1], start_date_num, end_date_num);
[trash, CDX] = wrapper_tranche_mispricing(get_x0(CDX, used_dates, method5, method2), CDX, discounts_IMM, start_date_num, end_date_num, N, ...
                                          maturities_cds, maturities_tranches, RMSE_method, LGD_method, 2, method5, method2, CDX2);

if (maturities_tranches(1) == 1)            
    % Calculate average CDS pricing bias for corresponding maturity
    avg_bias = plot_cds_bias(CDX, 1, 0, 0);
    
    % Calculate liq_error adjusted for CDS bias (using index PV_01 as proxy for average CDS PV01)
    liq_error_5yr = pv01_weighted_tranche_mispricing(CDX, start_date_num, end_date_num, [1 0 0]);
    liq_error_5yr = liq_error_5yr{1} - avg_bias(used_range) .* CDX.index_PV01{1}(used_range,:);     
end
if (maturities_tranches(2) == 1)
     % Calculate average CDS pricing bias for corresponding maturity
    avg_bias = plot_cds_bias(CDX, 2, 0, 0);
    
    % Calculate liq_error adjusted for CDS bias (using index PV_01 as proxy for average CDS PV01)
    liq_error_7yr = pv01_weighted_tranche_mispricing(CDX, start_date_num, end_date_num, [0 1 0]);
    liq_error_7yr = liq_error_7yr{2} - avg_bias(used_range2) .* CDX.index_PV01{2}(used_range2,:); 
end
if (maturities_tranches(3) == 1)
    % Calculate average CDS pricing bias for corresponding maturity
    avg_bias = plot_cds_bias(CDX, 3, 0, 0);
    
    % Calculate liq_error adjusted for CDS bias (using index PV_01 as proxy for average CDS PV01)
    liq_error_10yr = pv01_weighted_tranche_mispricing(CDX, start_date_num, end_date_num, [0 0 1]);
    liq_error_10yr = liq_error_10yr{3} - avg_bias(used_range3) .* CDX.index_PV01{3}(used_range3,:);   
end

% Sum up errors
liq_error = zeros(length(used_range), 1);
if (maturities_tranches(1) == 1)
    liq_error = liq_error + liq_error_5yr;
end
if (maturities_tranches(2) == 1)
    [trash, pos_5yr, pos_7yr] = intersect_sorted(used_range, used_range2);
    liq_error(pos_5yr) = liq_error(pos_5yr) + liq_error_7yr(pos_7yr);
end
if (maturities_tranches(3) == 1)
    [trash, pos_5yr, pos_10yr] = intersect_sorted(used_range, used_range3);
    liq_error(pos_5yr) = liq_error(pos_5yr) + liq_error_10yr(pos_10yr);
end

    
    
        
