%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit same date as in Mortensen (2006) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
warning off all
cdx_mor = subperiod_cdx(CDX_NA_IG2, datenum('12/05/2005'), datenum('12/05/2005'));
cdx_mor = initialize_parameters_cdx(cdx_mor, discounts_IMM, 106);
cdx_mor = fit_model_cds_portfolio(cdx_mor, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 0 0 1]);
cdx_mor = update_model_y0_v2(cdx_mor, discounts_IMM, 2^18, datenum('12/05/2005'), datenum('12/05/2005'), [1 0 0 1], [1 0 0], 1, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);

for i=1:1
cdx_mor = fit_model_cdx_xi4(1, cdx_mor, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1],[1 0 0], 1, 0, 2, 2);
cdx_mor = fit_model_cdx_xi4(2, cdx_mor, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1],[1 0 0], 1, 0, 2, 2);
cdx_mor = fit_model_cdx_xi4(3, cdx_mor, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1],[1 0 0], 1, 0, 2, 2);
cdx_mor = fit_model_cdx_xi4(4, cdx_mor, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1],[1 0 0], 1, 0, 2, 2);
cdx_mor = fit_model_cdx_xi4(5, cdx_mor, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1],[1 0 0], 1, 0, 2, 2);
cdx_mor = fit_model_cdx_xi4(6, cdx_mor, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1],[1 0 0], 1, 0, 2, 2);
cdx_mor = fit_model_cdx_xi4(7, cdx_mor, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1],[1 0 0], 1, 0, 2, 2);
cdx_mor = update_model_y0_v2(cdx_mor, discounts_IMM, 2^18, datenum('12/05/2005'), datenum('12/05/2005'), [1 0 0 1], [1 0 0], 1, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);
end

cdx_mor = fit_liq_prem_cds3(cdx_mor, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1], [1 0 0], 121, 0, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_mor = fit_liq_prem_tranches2(cdx_mor, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1], [1 0 0], 121, 0, 'mu*L', 'thet*k', CDX_NA_IG);

% cdx_mor = CDX_convert_parameters_AJD_idio(cdx_mor);
profile on; 
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_mor, cdx_mor.dates{1}, 'mu*L', 'thet*k'), cdx_mor, discounts_IMM, datenum('12/05/2005'), ...
                                           datenum('12/05/2005'), 2^18, [1 0 0 1], [1 0 0], 121, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);                                      
profile viewer; 

% Convert parameters to new infra-structure
test2 = CDX_convert_parameters_AJD_idio(cdx_mor);

% Deterministic LGD - param order: num_iter, relative, LGD_method, how_port_loss, update_cds_every_step
tic;
[cdx_mor, trash, x0_diff] = iterative_fitting(cdx_mor, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 0 0 1], [1 0 0], 2^18, ...
                                              2, 121, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
toc;
% cdx_mor = fit_model_cdx_dx([-4.6467e-4; 0.0024; 5.6888e-4; -1.7789e-4; 0.0082; 0.0031; 0;], cdx_mor, discounts_IMM, ...
%                            datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1], [1 0 0], 1, 0, 2, 2);

save_fitted_model(cdx_mor, 'Mort', datenum('12/05/2005'), datenum('12/05/2005'))
cdx_mor = load_fitted_model(cdx_mor, 'Mort');
cdx_mor = update_model_price_index(cdx_mor, discounts_IMM, [1 1 1], datenum('12/05/2005'),  datenum('12/05/2005'));

% Deterministic LGD with with fitting criterion RMSE_TR(5) + RMSE_CDS(1,5)                                      
cdx_mor_cds = cdx_mor;
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_mor_cds, cdx_mor_cds.dates{1}, 'mu*L', 'thet*k'), cdx_mor_cds, discounts_IMM, datenum('12/05/2005'), ...
                                           datenum('12/05/2005'), 2^18, [1 0 0 1], [1 0 0], 11, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);                                      
cdx_mor_cds = fit_liq_prem_cds3(cdx_mor_cds, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1], [1 0 0], 11, 0, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_mor_cds = fit_liq_prem_tranches2(cdx_mor_cds, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1], [1 0 0], 11, 0, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_mor_cds = iterative_fitting(cdx_mor_cds, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 0 0 1], [1 0 0], 2^18, 3, 11, 0, ...
                                ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
  
save_fitted_model(cdx_mor_cds, 'Mort_cds', datenum('12/05/2005'), datenum('12/05/2005'))
cdx_mor_cds = load_fitted_model(cdx_mor_cds, 'Mort_cds');                            

% Deterministic LGD - all horizons
cdx_mor10 = cdx_mor;
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_mor10), cdx_mor10, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), ...
                                           2^18, [1 1 1 0], [1 1 1], 121, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG); 
                                       
cdx_mor10 = fit_liq_prem_cds3(cdx_mor10, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 1 1 0], [1 1 1], 121, 0, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_mor10 = fit_liq_prem_tranches2(cdx_mor10, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 1 1 0], [1 1 1], 121, 0, 'mu*L', 'thet*k', CDX_NA_IG);    
tic;
cdx_mor10 = iterative_fitting(cdx_mor10, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 1 1 1], [1 1 1], 2^18, 3, 121, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
toc;
cdx_mor10 = update_model_price_index(cdx_mor10, discounts_IMM, [1 1 1], datenum('12/05/2005'),  datenum('12/05/2005'));
save_fitted_model(cdx_mor10, 'Mort10', datenum('12/05/2005'), datenum('12/05/2005'))
cdx_mor10 = load_fitted_model(cdx_mor10, 'Mort10');

% Deterministic LGD - all horizons 65% LGD   
cdx_mor10_LGD65 = cdx_mor10;
cdx_mor10_LGD65.LGD.mean = 0.65;
for i=1:length(cdx_mor10_LGD65.portfolio)
    cdx_mor10_LGD65.portfolio(i).LGD = 0.65;
end
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_mor10_LGD65, cdx_mor10_LGD65.dates{1}, 'mu*L', 'thet*k'), cdx_mor10_LGD65, discounts_IMM, ...
                                           datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 1 1 0], [1 1 1], 121, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);     
                     
cdx_mor10_LGD65 = fit_liq_prem_cds3(cdx_mor10_LGD65, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 1 1 0], [1 1 1], 121, 0, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_mor10_LGD65 = fit_liq_prem_tranches2(cdx_mor10_LGD65, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 1 1 0], [1 1 1], 121, 0, 'mu*L', 'thet*k', CDX_NA_IG);
tic;
cdx_mor10_LGD65  = iterative_fitting(cdx_mor10_LGD65, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 1 1 0], [1 1 1], 2^18, 2, 121, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
toc;

save_fitted_model(cdx_mor10_LGD65, 'Mort_LGD65', datenum('12/05/2005'), datenum('12/05/2005'))
cdx_mor10_LGD65 = load_fitted_model(cdx_mor10_LGD65, 'Mort_LGD65');                            
      
% Deterministic LGD - all horizons 75% LGD      
cdx_mor10_LGD75 = cdx_mor10;
cdx_mor10_LGD75.LGD.mean = 0.75;
for i=1:length(cdx_mor10_LGD75.portfolio)
    cdx_mor10_LGD75.portfolio(i).LGD = 0.75;
end
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_mor10_LGD75, cdx_mor10_LGD75.dates{1}, 'mu*L', 'thet*k'), cdx_mor10_LGD75, discounts_IMM, ...
                                           datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 1 1 0], [1 1 1], 121, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);     
                     
cdx_mor10_LGD75 = fit_liq_prem_cds3(cdx_mor10_LGD75, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 1 1 0], [1 1 1], 1, 0, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_mor10_LGD75 = fit_liq_prem_tranches2(cdx_mor10_LGD75, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 1 1 0], [1 1 1], 1, 0, 'mu*L', 'thet*k', CDX_NA_IG);
tic;
cdx_mor10_LGD75  = iterative_fitting(cdx_mor10_LGD75, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 1 1 0], [1 1 1], 2^18, 2, 121, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
toc;

save_fitted_model(cdx_mor10_LGD75, 'Mort_LGD75', datenum('12/05/2005'), datenum('12/05/2005'))
cdx_mor10_LGD75 = load_fitted_model(cdx_mor10_LGD75, 'Mort_LGD75');    

% % Deterministic LGD - liquidity weighted RMSE
% cdx_mor_liq = cdx_mor;
% [trash, test] = wrapper_tranche_mispricing(get_x0(cdx_mor_liq), cdx_mor_liq, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), ...
%                                            2^18, [1 0 0 0], [1 0 0], 2, 0, 2);
% cdx_mor_liq = iterative_fitting(cdx_mor_liq, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 1 0 0], [1 0 0], 2^18, 1, 2, 0, 0);
% save_fitted_model(cdx_mor_liq, 'Mort Liq', datenum('12/05/2005'), datenum('12/05/2005'))
% cdx_mor_liq = load_fitted_model(cdx_mor_liq, 'Mort Liq');

% Stochastic (but uncorrelated) LGD
cdx_mor_lgd1 = cdx_mor;
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_mor_lgd1), cdx_mor_lgd1, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), ...
                                           2^18, [1 0 0 1], [1 0 0], 121, 1, 2, 'mu*L', 'thet*k', CDX_NA_IG);
                                       
cdx_mor_lgd1 = fit_model_cds_portfolio(cdx_mor_lgd1, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 0 0 1], 'mu*L', 'thet*k', CDX_NA_IG);
cdx_mor_lgd1 = update_model_y0_v2(cdx_mor_lgd1, discounts_IMM, 2^18, datenum('12/05/2005'), datenum('12/05/2005'), [1 0 0], 1, 1, 'mu*L', 'thet*k', CDX_NA_IG);

cdx_mor_lgd1 = fit_liq_prem_cds3(cdx_mor_lgd1, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1], [1 0 0], 121, 1, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_mor_lgd1 = fit_liq_prem_tranches2(cdx_mor_lgd1, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1], [1 0 0], 121, 1, 'mu*L', 'thet*k', CDX_NA_IG);

cdx_mor_lgd1 = iterative_fitting(cdx_mor_lgd1, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 0 0 1], [1 0 0], 2^18, 20, 121, 1, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
save_fitted_model(cdx_mor_lgd1, 'Mort LGD1', datenum('12/05/2005'), datenum('12/05/2005'))
cdx_mor_lgd1 = load_fitted_model(cdx_mor_lgd1, 'Mort LGD1');

% Stochastic (but uncorrelated) LGD - all horizons
cdx_mor10_lgd1 = cdx_mor10;
profile on
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_mor10_lgd1), cdx_mor10_lgd1, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), ...
                                           2^18, [1 1 1 0], [1 1 1], 121, 1, 2, 'mu*L', 'thet*k', CDX_NA_IG);
profile viewer;                                       
                                    
cdx_mor10_lgd1 = fit_liq_prem_cds3(cdx_mor10_lgd1, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 1 1 0], [1 1 1], 121, 1, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_mor10_lgd1 = fit_liq_prem_tranches2(cdx_mor10_lgd1, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 1 1 0], [1 1 1], 121, 1, 'mu*L', 'thet*k', CDX_NA_IG);

tic;
cdx_mor10_lgd1 = iterative_fitting(cdx_mor10_lgd1, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 1 1 0], [1 1 1], 2^18, 2, 121, 1, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
toc;
save_fitted_model(cdx_mor10_lgd1, 'Mort10 LGD1', datenum('12/05/2005'), datenum('12/05/2005'))
cdx_mor10_lgd1 = load_fitted_model(cdx_mor10_lgd1, 'Mort10 LGD1');

% % Optimize stochastic and correlated LGD
% cdx_mor_lgd2 = cdx_mor;
% [trash, test] = wrapper_tranche_mispricing(get_x0(cdx_mor_lgd2), cdx_mor_lgd2, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), ...
%                                            2^18, [1 0 0 0], [1 0 0], 1, 2, 2);
%                                        
% cdx_mor_lgd2 = fit_liq_prem_cds3(cdx_mor_lgd2, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1], [1 0 0], 1, 1);
% cdx_mor_lgd2 = fit_liq_prem_tranches2(cdx_mor_lgd2, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1], [1 0 0], 1, 0);
% 
% cdx_mor_lgd2 = iterative_fitting(cdx_mor_lgd2, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 0 0 1], [1 0 0], 2^18, 1, 1, 2, 0);
% [alpha_n_rel, cdx_mor_lgd2] = optimize_alpha_n(cdx_mor_lgd2, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 0], [1 0 0], 1, 0.01);
% save_fitted_model(cdx_mor_lgd2, 'Mort LGD2', datenum('12/05/2005'), datenum('12/05/2005'))
%                                   
% Stochastic and serially correlated LGD
cdx_mor_lgd3 = cdx_mor;
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_mor_lgd3), cdx_mor_lgd3, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), ...
                                           2^18, [1 0 0 1], [1 0 0], 121, 3, 2, 'mu*L', 'thet*k', CDX_NA_IG);

cdx_mor_lgd3 = fit_liq_prem_cds3(cdx_mor_lgd3, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1], [1 0 0], 121, 3, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_mor_lgd3 = fit_liq_prem_tranches2(cdx_mor_lgd3, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 1], [1 0 0], 121, 3, 'mu*L', 'thet*k', CDX_NA_IG);

cdx_mor_lgd3 = iterative_fitting(cdx_mor_lgd3, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 0 0 1], [1 0 0], 2^18, 2, 121, 3, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
[rho_n, cdx_mor_lgd3] = optimize_rho_n(cdx_mor_lgd3, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 0 0 0], [1 0 0], 121, 0.05, 'mu*L', 'thet*k', CDX_NA_IG);
save_fitted_model(cdx_mor_lgd3, 'Mort LGD3', datenum('12/05/2005'), datenum('12/05/2005'))
cdx_mor_lgd3 = load_fitted_model(cdx_mor_lgd3, 'Mort LGD3');


% Stochastic and serially correlated LGD - all horizons
cdx_mor10_lgd3 = cdx_mor10;
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_mor10_lgd3), cdx_mor10_lgd3, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), ...
                                           2^18, [1 1 1 0], [1 1 1], 121, 3, 2, 'mu*L', 'thet*k', CDX_NA_IG);

cdx_mor10_lgd3 = fit_liq_prem_cds3(cdx_mor10_lgd3, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 1 1 0], [1 1 1], 121, 3, 'mu*L', 'thet*k', CDX_NA_IG);
cdx_mor10_lgd3 = fit_liq_prem_tranches2(cdx_mor10_lgd3, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 1 1 0], [1 1 1], 121, 3, 'mu*L', 'thet*k', CDX_NA_IG);

tic;
cdx_mor10_lgd3 = iterative_fitting(cdx_mor10_lgd3, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 1 1 0], [1 1 1], 2^18, 2, 121, 3, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
toc;
tic;
[rho_n, cdx_mor10_lgd3] = optimize_rho_n(cdx_mor10_lgd3, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), 2^18, [1 1 1 0], [1 1 1], 121, 0.05, 'mu*L', 'thet*k', CDX_NA_IG);
toc;
save_fitted_model(cdx_mor10_lgd3, 'Mort10 LGD3', datenum('12/05/2005'), datenum('12/05/2005'))
cdx_mor10_lgd3 = load_fitted_model(cdx_mor10_lgd3, 'Mort10 LGD3');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit same date as Papageorgiou and Sircar (2007) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
cdx_PS = subperiod_cdx(CDX_NA_IG2, datenum('10/31/2006'), datenum('10/31/2006'));
cdx_PS = initialize_parameters_cdx(cdx_PS, discounts_IMM, 106);
%cdx_PS = CDX_convert_parameters_AJD_idio(cdx_PS);

[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_PS, cdx_PS.dates{1}, 'mu*L', 'thet*k'), cdx_PS, discounts_IMM, datenum('10/31/2006'), ...
                                           datenum('10/31/2006'), 2^18, [1 0 0 1], [1 0 0], 121, 0, 2, 'mu*L', 'thet*k', CDX_NA_IG);                                      

tic;
cdx_PS = iterative_fitting(cdx_PS, discounts_IMM, datenum('10/31/2006'), datenum('10/31/2006'), [1 0 0 1], [1 0 0], 2^18, ...
                           2, 121, 0, ones(10,1), 'mu*L', 'thet*k', CDX_NA_IG);
toc;

save_fitted_model(cdx_PS, 'PapSir', datenum('10/31/2006'), datenum('10/31/2006'))
cdx_PS = load_fitted_model(cdx_PS, 'PapSir');
cdx_PS = update_model_price_index(cdx_PS, discounts_IMM, [1 1 1], datenum('10/31/2006'),  datenum('10/31/2006'));

% %%%%%%%%%%%%%%%%%%%
% % Fit yearly data % 
% %%%%%%%%%%%%%%%%%%%
% warning off all
% cdx_yearly = subperiod_cdx2(CDX_NA_IG2, [datenum('09/21/2004'); datenum('12/01/2005'); datenum('11/01/2006')]);
% cdx_yearly = initialize_parameters_cdx(cdx_yearly, discounts_IMM, 2);
% cdx_yearly = fit_model_cds_portfolio(cdx_yearly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), [1 0 0 1]);
% 
% [trash, test] = wrapper_tranche_mispricing(get_x0(cdx_yearly), cdx_yearly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), ...
%                                            2^18, [1 0 0 0], [1 0 0], 1, 0, 2);
% 
% cdx_yearly = iterative_fitting(cdx_yearly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), [1 0 0 0], [1 0 0], 2^18, 1, 1, 0);
% save_fitted_model(cdx_yearly, 'yearly', datenum('09/21/2004'), datenum('11/01/2006'))
% 
% %%%%%%%%%%%%%%%%%%
% % Fit four dates %
% %%%%%%%%%%%%%%%%%%
% warning off all
% cdx_new4 = subperiod_cdx(CDX_NA_IG2_monthly, datenum('02/01/2006'), datenum('05/01/2006'));
% cdx_new4 = initialize_parameters_cdx(cdx_new4, discounts_IMM, 104);
% [trash, test] = wrapper_tranche_mispricing(get_x0(cdx_new4), cdx_new4, discounts_IMM, datenum('02/01/2006'), datenum('05/01/2006'), 2^18, [1 0 0 0], [1 0 0], 1, 0);
% 
% cdx_new4 = iterative_fitting(cdx_new4, discounts_IMM, datenum('02/01/2006'), datenum('05/01/2006'), [1 1 0 0], [1 0 0], 1, 1, 2, 1);
% 
% %%%%%%%%%%%%%%%%%%%%
% % Fit monthly data %
% %%%%%%%%%%%%%%%%%%%%
% warning off all
% CDX_NA_IG2_monthly = subperiod_cdx(CDX_NA_IG2_monthly, CDX_NA_IG2_monthly.dates{1}(1), CDX_NA_IG2_monthly.dates{1}(end));
% cdx_monthly = initialize_parameters_cdx(CDX_NA_IG2_monthly, discounts_IMM, 3);
% cdx_monthly = fit_model_cds_portfolio(cdx_monthly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), [1 0 0 1]);
% cdx_monthly = update_model_y0_v2(cdx_monthly, discounts_IMM, 2^18, datenum('09/21/2004'), datenum('11/01/2006'), [1 0 0 1], [1 0 0], 1, 0);
% cdx_monthly = fit_liq_prem_cds3(cdx_monthly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^18, [1 0 0 0], [1 0 0], 1, 0);
% profile on;
% [trash, test] = wrapper_tranche_mispricing(get_x0(cdx_monthly), cdx_monthly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), ...
%                                            2^18, [1 0 0 1], [1 0 0], 1, 0, 2);
% profile off;                                       
% 
% cdx_monthly = fit_model_cdx_xi4(1, cdx_monthly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^18, [1 0 0 1], [1 0 0], 1, 0, 2);
% cdx_monthly = fit_model_cdx_xi4(2, cdx_monthly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^18, [1 0 0 1], [1 0 0], 1, 0, 2);
% cdx_monthly = fit_model_cdx_xi4(3, cdx_monthly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^18, [1 0 0 1], [1 0 0], 1, 0, 2);
% cdx_monthly = fit_model_cdx_xi4(4, cdx_monthly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^18, [1 0 0 1], [1 0 0], 1, 0, 2);
% cdx_monthly = fit_model_cdx_xi4(5, cdx_monthly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^18, [1 0 0 1], [1 0 0], 1, 0, 2);
% cdx_monthly = fit_model_cdx_xi4(6, cdx_monthly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^18, [1 0 0 1], [1 0 0], 1, 0, 2);
% cdx_monthly = fit_model_cdx_xi4(7, cdx_monthly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), 2^18, [1 0 0 1], [1 0 0], 1, 0, 2);
% 
% cdx_monthly = iterative_fitting(cdx_monthly, discounts_IMM, datenum('09/21/2004'), datenum('11/01/2006'), [1 0 0 1], [1 0 0], 2^18, 1, 1, 0);
% save_fitted_model(cdx_monthly, 'monthly', datenum('09/21/2004'), datenum('11/01/2006'))
% cdx_monthly = load_fitted_model(cdx_monthly, 'monthly');