%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit individual CDS price time series %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Set parameters for optimization
start_date = datenum('10/02/2006');
end_date = datenum('11/01/2006');

% Test speed of wrapper function for Newton-Raphson
profile on; wrapper_CDS_mispricing2(0.5, CDX_NA_IG2_monthly.portfolio(1), CDX_NA_IG2_monthly, discounts_IMM, start_date, end_date); profile viewer;

% Fit factor loading and idiosyncratic intensity dynamics to CDS prices
profile on;
[cds_new, rmse] = fit_model_cds4(CDX_NA_IG2_monthly.portfolio(1), discounts_IMM, CDX_NA_IG2_monthly, start_date, end_date, [1 0 0 1]);
profile viewer;

% With daily frequency
cds_test2 = CDX_NA_IG2_monthly.portfolio(2);
[cds_test2, rsme] = fit_model_cds(cds_test2, discounts_IMM, CDX_NA_IG2_monthly);
plot_intensity_idosyncratic(cds_test2);